/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j.grid.jcache;

import com.github.bucket4j.grid.CommandResult;
import com.github.bucket4j.grid.GridBucketState;
import com.github.bucket4j.grid.GridCommand;
import com.github.bucket4j.grid.GridProxy;
import com.github.bucket4j.grid.jcache.JCacheCommand;
import java.io.Serializable;
import javax.cache.Cache;

public class JCacheProxy<K extends Serializable>
implements GridProxy {
    private final Cache<K, GridBucketState> cache;
    private final K key;

    public JCacheProxy(Cache<K, GridBucketState> cache, K key) {
        this.cache = cache;
        this.key = key;
    }

    public CommandResult execute(GridCommand command) {
        return (CommandResult)this.cache.invoke(this.key, new JCacheCommand(), new Object[]{command});
    }

    @Override
    public void setInitialState(GridBucketState initialState) {
        this.cache.putIfAbsent(this.key, (Object)initialState);
    }

    public Serializable getBucketKey() {
        return this.key;
    }
}

