/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j.grid;

import com.github.bucket4j.Bandwidth;
import com.github.bucket4j.BucketConfiguration;
import com.github.bucket4j.BucketState;
import com.github.bucket4j.grid.GridBucketState;
import com.github.bucket4j.grid.GridCommand;

public class TryConsumeCommand
implements GridCommand<Boolean> {
    private long tokensToConsume;
    private boolean bucketStateModified;

    public TryConsumeCommand(long tokensToConsume) {
        this.tokensToConsume = tokensToConsume;
    }

    @Override
    public Boolean execute(GridBucketState gridState) {
        BucketConfiguration configuration = gridState.getBucketConfiguration();
        BucketState state = gridState.getBucketState();
        long currentTimeNanos = configuration.getTimeMeter().currentTimeNanos();
        Bandwidth[] bandwidths = configuration.getBandwidths();
        state.refillAllBandwidth(bandwidths, currentTimeNanos);
        long availableToConsume = state.getAvailableTokens(bandwidths);
        if (this.tokensToConsume <= availableToConsume) {
            state.consume(bandwidths, this.tokensToConsume);
            this.bucketStateModified = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBucketStateModified() {
        return this.bucketStateModified;
    }
}

