/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j.grid;

import com.github.bucket4j.AbstractBucket;
import com.github.bucket4j.BucketConfiguration;
import com.github.bucket4j.BucketState;
import com.github.bucket4j.grid.BucketNotFoundException;
import com.github.bucket4j.grid.CommandResult;
import com.github.bucket4j.grid.ConsumeAsMuchAsPossibleCommand;
import com.github.bucket4j.grid.ConsumeOrCalculateTimeToCloseDeficitCommand;
import com.github.bucket4j.grid.CreateSnapshotCommand;
import com.github.bucket4j.grid.GridBucketState;
import com.github.bucket4j.grid.GridCommand;
import com.github.bucket4j.grid.GridProxy;
import com.github.bucket4j.grid.RecoveryStrategy;
import com.github.bucket4j.grid.TryConsumeCommand;
import java.io.Serializable;

public class GridBucket
extends AbstractBucket {
    private final GridProxy gridProxy;
    private final RecoveryStrategy recoveryStrategy;

    public GridBucket(BucketConfiguration configuration, GridProxy gridProxy, RecoveryStrategy recoveryStrategy) {
        super(configuration);
        this.gridProxy = gridProxy;
        this.recoveryStrategy = recoveryStrategy;
        this.initializeBucket();
    }

    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        return this.execute(new ConsumeAsMuchAsPossibleCommand(limit));
    }

    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        return this.execute(new TryConsumeCommand(tokensToConsume));
    }

    @Override
    protected boolean consumeOrAwaitImpl(long tokensToConsume, long waitIfBusyTimeLimit) throws InterruptedException {
        long methodStartTimeNanos;
        boolean isWaitingLimited = waitIfBusyTimeLimit > 0L;
        ConsumeOrCalculateTimeToCloseDeficitCommand consumeCommand = new ConsumeOrCalculateTimeToCloseDeficitCommand(tokensToConsume);
        long l = methodStartTimeNanos = isWaitingLimited ? this.configuration.getTimeMeter().currentTimeNanos() : 0L;
        long nanosToCloseDeficit;
        while ((nanosToCloseDeficit = this.execute(consumeCommand).longValue()) != 0L) {
            if (nanosToCloseDeficit == Long.MAX_VALUE) {
                return false;
            }
            if (isWaitingLimited) {
                long currentTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
                long methodDuration = currentTimeNanos - methodStartTimeNanos;
                if (methodDuration >= waitIfBusyTimeLimit) {
                    return false;
                }
                long sleepingTimeLimit = waitIfBusyTimeLimit - methodDuration;
                if (nanosToCloseDeficit >= sleepingTimeLimit) {
                    return false;
                }
            }
            this.configuration.getTimeMeter().parkNanos(nanosToCloseDeficit);
        }
        return true;
    }

    @Override
    public BucketState createSnapshot() {
        return this.execute(new CreateSnapshotCommand());
    }

    private <T extends Serializable> T execute(GridCommand<T> command) {
        CommandResult<T> result = this.gridProxy.execute(command);
        if (!result.isBucketNotFound()) {
            return (T)((Serializable)result.getData());
        }
        if (this.recoveryStrategy == RecoveryStrategy.THROW_BUCKET_NOT_FOUND_EXCEPTION) {
            throw new BucketNotFoundException((Serializable)this.gridProxy.getBucketKey());
        }
        this.initializeBucket();
        result = this.gridProxy.execute(command);
        if (!result.isBucketNotFound()) {
            return (T)((Serializable)result.getData());
        }
        throw new BucketNotFoundException((Serializable)this.gridProxy.getBucketKey());
    }

    private void initializeBucket() {
        GridBucketState initialState = new GridBucketState(this.configuration, BucketState.createInitialState(this.configuration));
        this.gridProxy.setInitialState(initialState);
    }
}

