/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j.grid;

import com.github.bucket4j.Bandwidth;
import com.github.bucket4j.BucketConfiguration;
import com.github.bucket4j.BucketState;
import com.github.bucket4j.grid.GridBucketState;
import com.github.bucket4j.grid.GridCommand;

public class ConsumeOrCalculateTimeToCloseDeficitCommand
implements GridCommand<Long> {
    private long tokensToConsume;
    private boolean bucketStateModified;

    public ConsumeOrCalculateTimeToCloseDeficitCommand(long tokensToConsume) {
        this.tokensToConsume = tokensToConsume;
    }

    @Override
    public Long execute(GridBucketState gridState) {
        BucketConfiguration configuration = gridState.getBucketConfiguration();
        BucketState state = gridState.getBucketState();
        long currentTimeNanos = configuration.getTimeMeter().currentTimeNanos();
        Bandwidth[] bandwidths = configuration.getBandwidths();
        state.refillAllBandwidth(bandwidths, currentTimeNanos);
        long timeToCloseDeficit = state.delayNanosAfterWillBePossibleToConsume(bandwidths, currentTimeNanos, this.tokensToConsume);
        if (timeToCloseDeficit == 0L) {
            state.consume(bandwidths, this.tokensToConsume);
            this.bucketStateModified = true;
        }
        return timeToCloseDeficit;
    }

    @Override
    public boolean isBucketStateModified() {
        return this.bucketStateModified;
    }
}

