/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j;

import com.github.bucket4j.BucketExceptions;
import java.io.Serializable;

public interface Capacity
extends Serializable {
    public long getValue(long var1);

    public static Capacity constant(long value) {
        return new ImmutableCapacity(value);
    }

    public static class ImmutableCapacity
    implements Capacity {
        private final long value;

        private ImmutableCapacity(long value) {
            if (value <= 0L) {
                throw BucketExceptions.nonPositiveCapacity(value);
            }
            this.value = value;
        }

        @Override
        public long getValue(long currentTime) {
            return this.value;
        }

        public String toString() {
            return "ImmutableCapacity{value=" + this.value + '}';
        }
    }
}

