/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j;

import com.github.bucket4j.Bandwidth;
import com.github.bucket4j.BucketExceptions;

class BandwidthDefinition {
    private final Bandwidth bandwidth;
    private final long initialTokens;

    private BandwidthDefinition(Bandwidth bandwidth, long initialTokens) {
        this.bandwidth = bandwidth;
        this.initialTokens = initialTokens;
    }

    public static BandwidthDefinition withInitialTokens(Bandwidth bandwidth, long initialTokens) {
        if (bandwidth == null) {
            throw BucketExceptions.nullBandwidth();
        }
        if (initialTokens < 0L) {
            throw BucketExceptions.nonPositiveInitialTokens(initialTokens);
        }
        return new BandwidthDefinition(bandwidth, initialTokens);
    }

    public static BandwidthDefinition unspecifiedInitialTokens(Bandwidth bandwidth) {
        if (bandwidth == null) {
            throw BucketExceptions.nullBandwidth();
        }
        return new BandwidthDefinition(bandwidth, -1L);
    }

    public Bandwidth getBandwidth() {
        return this.bandwidth;
    }

    public long getInitialTokens() {
        return this.initialTokens;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BandwidthDefinition{");
        sb.append("bandwidth=").append(this.bandwidth);
        sb.append(", initialTokens=").append(this.initialTokens);
        sb.append('}');
        return sb.toString();
    }
}

