/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j;

import com.github.bucket4j.BucketExceptions;
import com.github.bucket4j.Capacity;
import com.github.bucket4j.Refill;
import java.io.Serializable;
import java.time.Duration;

public class Bandwidth
implements Serializable {
    private final Capacity capacity;
    private final Refill refill;

    private Bandwidth(Capacity capacity, Refill refill) {
        if (capacity == null) {
            throw BucketExceptions.nullBandwidthCapacity();
        }
        if (refill == null) {
            throw BucketExceptions.nullBandwidthRefill();
        }
        this.capacity = capacity;
        this.refill = refill;
    }

    public static Bandwidth simple(long capacity, Duration period) {
        return new Bandwidth(Capacity.constant(capacity), Refill.smooth(capacity, period));
    }

    public static Bandwidth classic(long capacity, Refill refill) {
        return new Bandwidth(Capacity.constant(capacity), refill);
    }

    public static Bandwidth classic(Capacity capacity, Refill refill) {
        return new Bandwidth(capacity, refill);
    }

    Refill getRefill() {
        return this.refill;
    }

    Capacity getCapacity() {
        return this.capacity;
    }

    public String toString() {
        return "Bandwidth{capacity=" + this.capacity + ", refill=" + this.refill + '}';
    }
}

