/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j;

import com.github.bucket4j.Bandwidth;
import com.github.bucket4j.BandwidthDefinition;
import com.github.bucket4j.BucketConfiguration;
import com.github.bucket4j.BucketExceptions;
import com.github.bucket4j.TimeMeter;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBucketBuilder<T extends AbstractBucketBuilder> {
    private TimeMeter timeMeter = TimeMeter.SYSTEM_MILLISECONDS;
    private List<BandwidthDefinition> bandwidths = new ArrayList<BandwidthDefinition>(1);

    public T addLimit(Bandwidth bandwidth) {
        this.bandwidths.add(BandwidthDefinition.unspecifiedInitialTokens(bandwidth));
        return (T)this;
    }

    public T addLimit(long initialTokens, Bandwidth bandwidth) {
        this.bandwidths.add(BandwidthDefinition.withInitialTokens(bandwidth, initialTokens));
        return (T)this;
    }

    public T withNanosecondPrecision() {
        this.timeMeter = TimeMeter.SYSTEM_NANOTIME;
        return (T)this;
    }

    public T withMillisecondPrecision() {
        this.timeMeter = TimeMeter.SYSTEM_MILLISECONDS;
        return (T)this;
    }

    public T withCustomTimePrecision(TimeMeter customTimeMeter) {
        if (customTimeMeter == null) {
            throw BucketExceptions.nullTimeMeter();
        }
        this.timeMeter = customTimeMeter;
        return (T)this;
    }

    public BucketConfiguration createConfiguration() {
        return new BucketConfiguration(this.bandwidths, this.timeMeter);
    }

    public String toString() {
        return "AbstractBucketBuilder{timeMeter=" + this.timeMeter + ", bandwidths=" + this.bandwidths + '}';
    }
}

