/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j;

import com.github.bucket4j.Bucket;
import com.github.bucket4j.BucketConfiguration;
import com.github.bucket4j.BucketExceptions;

public abstract class AbstractBucket
implements Bucket {
    protected static final long UNSPECIFIED_WAITING_LIMIT = -1L;
    protected final BucketConfiguration configuration;

    protected AbstractBucket(BucketConfiguration configuration) {
        this.configuration = configuration;
    }

    protected abstract long consumeAsMuchAsPossibleImpl(long var1);

    protected abstract boolean tryConsumeImpl(long var1);

    protected abstract boolean consumeOrAwaitImpl(long var1, long var3) throws InterruptedException;

    @Override
    public boolean tryConsumeSingleToken() {
        return this.tryConsumeImpl(1L);
    }

    @Override
    public boolean tryConsume(long tokensToConsume) {
        if (tokensToConsume <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(tokensToConsume);
        }
        return this.tryConsumeImpl(tokensToConsume);
    }

    @Override
    public void consumeSingleToken() throws InterruptedException {
        this.consume(1L);
    }

    @Override
    public void consume(long tokensToConsume) throws InterruptedException {
        if (tokensToConsume <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(tokensToConsume);
        }
        this.consumeOrAwaitImpl(tokensToConsume, -1L);
    }

    @Override
    public boolean consumeSingleToken(long maxWaitTime) throws InterruptedException {
        return this.consume(1L, maxWaitTime);
    }

    @Override
    public boolean consume(long tokensToConsume, long maxWaitTime) throws InterruptedException {
        if (tokensToConsume <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(tokensToConsume);
        }
        if (maxWaitTime <= 0L) {
            throw BucketExceptions.nonPositiveNanosToWait(maxWaitTime);
        }
        return this.consumeOrAwaitImpl(tokensToConsume, maxWaitTime);
    }

    @Override
    public long tryConsumeAsMuchAsPossible(long limit) {
        if (limit <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(limit);
        }
        return this.consumeAsMuchAsPossibleImpl(limit);
    }

    @Override
    public long tryConsumeAsMuchAsPossible() {
        return this.consumeAsMuchAsPossibleImpl(Long.MAX_VALUE);
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }
}

