/*
 * Decompiled with CFR 0.152.
 */
package com.github.buchandersenn.android_permission_manager;

import android.support.annotation.NonNull;
import com.github.buchandersenn.android_permission_manager.PermissionManager;
import com.github.buchandersenn.android_permission_manager.PermissionRequest;
import com.github.buchandersenn.android_permission_manager.callbacks.OnPermissionCallback;
import com.github.buchandersenn.android_permission_manager.callbacks.OnPermissionDeniedCallback;
import com.github.buchandersenn.android_permission_manager.callbacks.OnPermissionGrantedCallback;
import com.github.buchandersenn.android_permission_manager.callbacks.OnPermissionShowRationaleCallback;

public class PermissionRequestBuilder {
    @NonNull
    private final PermissionManager manager;
    @NonNull
    private final String[] permissions;
    private int requestCode = -1;
    private OnPermissionGrantedCallback grantedCallback;
    private OnPermissionDeniedCallback deniedCallback;
    private OnPermissionShowRationaleCallback showRationaleCallback;

    PermissionRequestBuilder(@NonNull PermissionManager manager, @NonNull String[] permissions) {
        this.manager = manager;
        this.permissions = permissions;
    }

    public PermissionRequestBuilder usingRequestCode(int requestCode) {
        this.requestCode = requestCode;
        return this;
    }

    public PermissionRequestBuilder onCallback(OnPermissionCallback callback) {
        this.grantedCallback = callback;
        this.deniedCallback = callback;
        this.showRationaleCallback = callback;
        return this;
    }

    public PermissionRequestBuilder onPermissionGranted(OnPermissionGrantedCallback callback) {
        this.grantedCallback = callback;
        return this;
    }

    public PermissionRequestBuilder onPermissionDenied(OnPermissionDeniedCallback callback) {
        this.deniedCallback = callback;
        return this;
    }

    public PermissionRequestBuilder onPermissionShowRationale(OnPermissionShowRationaleCallback callback) {
        this.showRationaleCallback = callback;
        return this;
    }

    public void request() {
        PermissionRequest permissionRequest = new PermissionRequest(this.manager, this.permissions, this.requestCode, this.grantedCallback, this.deniedCallback, this.showRationaleCallback);
        this.manager.request(permissionRequest);
    }

    public void check() {
        PermissionRequest permissionRequest = new PermissionRequest(this.manager, this.permissions, this.requestCode, this.grantedCallback, this.deniedCallback, this.showRationaleCallback);
        this.manager.check(permissionRequest);
    }
}

