/*
 * Decompiled with CFR 0.152.
 */
package com.desmond.squarecamera;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import com.desmond.squarecamera.R;
import java.util.ArrayList;
import java.util.Arrays;

public class RuntimePermissionActivity
extends AppCompatActivity {
    public static final String REQUESTED_PERMISSION = "requested_permission";
    private static final int REQUEST_CODE = 1;

    public static void startActivity(@NonNull Fragment fragment, int requestCode, @NonNull String requestedPermission, String ... permissions) {
        Intent intent = new Intent((Context)fragment.getActivity(), RuntimePermissionActivity.class);
        int capacity = 1 + (permissions != null ? permissions.length : 0);
        ArrayList<String> requestedPermissions = new ArrayList<String>(capacity);
        requestedPermissions.add(requestedPermission);
        if (permissions != null) {
            requestedPermissions.addAll(Arrays.asList(permissions));
        }
        intent.putStringArrayListExtra(REQUESTED_PERMISSION, requestedPermissions);
        fragment.startActivityForResult(intent, requestCode);
    }

    protected void onStart() {
        super.onStart();
        this.setVisible(true);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ArrayList reqPermissions = this.getIntent().getStringArrayListExtra(REQUESTED_PERMISSION);
        ArrayList<String> permissionsNeeded = this.getPermissionNeeded(reqPermissions);
        ArrayList<String> permissionRationaleNeeded = this.getPermissionRationaleNeeded(permissionsNeeded);
        if (!permissionRationaleNeeded.isEmpty()) {
            String message = this.getString(R.string.squarecamera__request_write_storage_permission_text);
            for (int i = 1; i < permissionRationaleNeeded.size(); ++i) {
                message = message + ", " + permissionRationaleNeeded.get(i);
            }
            this.showPermissionRationaleDialog(message, permissionsNeeded.toArray(new String[permissionsNeeded.size()]));
        } else if (!permissionsNeeded.isEmpty()) {
            this.requestForPermission(permissionsNeeded.toArray(new String[permissionsNeeded.size()]));
        } else {
            this.sendResult(true);
        }
    }

    private ArrayList<String> getPermissionNeeded(@NonNull ArrayList<String> reqPermissions) {
        ArrayList<String> permissionNeeded = new ArrayList<String>(reqPermissions.size());
        for (String reqPermission : reqPermissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)reqPermission) == 0) continue;
            permissionNeeded.add(reqPermission);
        }
        return permissionNeeded;
    }

    private ArrayList<String> getPermissionRationaleNeeded(@NonNull ArrayList<String> permissionsNeeded) {
        ArrayList<String> rationaleNeeded = new ArrayList<String>(permissionsNeeded.size());
        for (String permissionNeeded : permissionsNeeded) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permissionNeeded)) continue;
            rationaleNeeded.add(permissionNeeded);
        }
        return rationaleNeeded;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 1: {
                int numOfRequest = grantResults.length;
                boolean isGranted = true;
                for (int i = 0; i < numOfRequest; ++i) {
                    if (0 == grantResults[i]) continue;
                    isGranted = false;
                    break;
                }
                this.sendResult(isGranted);
                break;
            }
            default: {
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }

    private void showPermissionRationaleDialog(String message, final String[] permissions) {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)message).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RuntimePermissionActivity.this.requestForPermission(permissions);
            }
        }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RuntimePermissionActivity.this.sendResult(false);
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                RuntimePermissionActivity.this.sendResult(false);
            }
        }).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                RuntimePermissionActivity.this.sendResult(false);
            }
        }).create().show();
    }

    private void requestForPermission(String[] permissions) {
        ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)1);
    }

    private void sendResult(boolean isPermissionGranted) {
        Intent resultIntent = new Intent();
        resultIntent.putExtra(REQUESTED_PERMISSION, isPermissionGranted);
        this.setResult(-1, resultIntent);
        this.finish();
    }
}

