/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.session;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import me.chanjar.weixin.common.session.InternalSession;
import me.chanjar.weixin.common.session.InternalSessionManager;
import me.chanjar.weixin.common.session.StandardSessionFacade;
import me.chanjar.weixin.common.session.WxSession;
import me.chanjar.weixin.common.util.res.StringManager;

public class StandardSession
implements WxSession,
InternalSession {
    protected static final StringManager sm = StringManager.getManager("me.chanjar.weixin.common.session");
    protected static final String[] EMPTY_ARRAY = new String[0];
    protected Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    protected String id = null;
    protected volatile boolean isValid = false;
    protected volatile transient boolean expiring = false;
    protected transient InternalSessionManager manager = null;
    protected long creationTime;
    protected volatile long thisAccessedTime = this.creationTime = 0L;
    protected int maxInactiveInterval = 1800;
    protected transient StandardSessionFacade facade = null;
    protected transient AtomicInteger accessCount = null;

    public StandardSession(InternalSessionManager manager) {
        this.manager = manager;
        this.accessCount = new AtomicInteger();
    }

    @Override
    public Object getAttribute(String name) {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("sessionImpl.getAttribute.ise"));
        }
        if (name == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("sessionImpl.getAttributeNames.ise"));
        }
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.attributes.keySet());
        return Collections.enumeration(names);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("sessionImpl.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("sessionImpl.setAttribute.ise", this.getIdInternal()));
        }
        this.attributes.put(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.removeAttributeInternal(name);
    }

    @Override
    public void invalidate() {
        if (!this.isValidInternal()) {
            throw new IllegalStateException(sm.getString("sessionImpl.invalidate.ise"));
        }
        this.expire();
    }

    @Override
    public WxSession getSession() {
        if (this.facade == null) {
            this.facade = new StandardSessionFacade(this);
        }
        return this.facade;
    }

    protected boolean isValidInternal() {
        return this.isValid;
    }

    @Override
    public boolean isValid() {
        long timeNow;
        int timeIdle;
        if (!this.isValid) {
            return false;
        }
        if (this.expiring) {
            return true;
        }
        if (this.accessCount.get() > 0) {
            return true;
        }
        if (this.maxInactiveInterval > 0 && (timeIdle = (int)(((timeNow = System.currentTimeMillis()) - this.thisAccessedTime) / 1000L)) >= this.maxInactiveInterval) {
            this.expire();
        }
        return this.isValid;
    }

    @Override
    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    @Override
    public String getIdInternal() {
        return this.id;
    }

    protected void removeAttributeInternal(String name) {
        if (name == null) {
            return;
        }
        this.attributes.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire() {
        if (!this.isValid) {
            return;
        }
        StandardSession standardSession = this;
        synchronized (standardSession) {
            if (this.expiring || !this.isValid) {
                return;
            }
            if (this.manager == null) {
                return;
            }
            this.expiring = true;
            this.accessCount.set(0);
            this.manager.remove(this, true);
            this.setValid(false);
            this.expiring = false;
            String[] keys = this.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.removeAttributeInternal(keys[i]);
            }
        }
    }

    @Override
    public void access() {
        this.thisAccessedTime = System.currentTimeMillis();
        this.accessCount.incrementAndGet();
    }

    @Override
    public void endAccess() {
        this.thisAccessedTime = System.currentTimeMillis();
        this.accessCount.decrementAndGet();
    }

    @Override
    public void setCreationTime(long time) {
        this.creationTime = time;
        this.thisAccessedTime = time;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    @Override
    public void setId(String id) {
        if (this.id != null && this.manager != null) {
            this.manager.remove(this);
        }
        this.id = id;
        if (this.manager != null) {
            this.manager.add(this);
        }
    }

    protected String[] keys() {
        return this.attributes.keySet().toArray(EMPTY_ARRAY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandardSession)) {
            return false;
        }
        StandardSession session = (StandardSession)o;
        if (this.creationTime != session.creationTime) {
            return false;
        }
        if (this.expiring != session.expiring) {
            return false;
        }
        if (this.isValid != session.isValid) {
            return false;
        }
        if (this.maxInactiveInterval != session.maxInactiveInterval) {
            return false;
        }
        if (this.thisAccessedTime != session.thisAccessedTime) {
            return false;
        }
        if (!this.accessCount.equals(session.accessCount)) {
            return false;
        }
        if (!this.attributes.equals(session.attributes)) {
            return false;
        }
        if (!this.facade.equals(session.facade)) {
            return false;
        }
        if (!this.id.equals(session.id)) {
            return false;
        }
        return this.manager.equals(session.manager);
    }

    public int hashCode() {
        int result = this.attributes.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.isValid ? 1 : 0);
        result = 31 * result + (this.expiring ? 1 : 0);
        result = 31 * result + this.manager.hashCode();
        result = 31 * result + (int)(this.creationTime ^ this.creationTime >>> 32);
        result = 31 * result + (int)(this.thisAccessedTime ^ this.thisAccessedTime >>> 32);
        result = 31 * result + this.maxInactiveInterval;
        result = 31 * result + this.facade.hashCode();
        result = 31 * result + this.accessCount.hashCode();
        return result;
    }
}

