/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.uibasics.views;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.bijoysingh.uibasics.R;
import com.github.bijoysingh.uibasics.attributes.ImageAttributes;
import com.github.bijoysingh.uibasics.attributes.TextAttributes;
import com.github.bijoysingh.uibasics.base.CustomLinearLayout;

public class FigTextView
extends CustomLinearLayout {
    private ImageView mIcon;
    private TextView mLabel;

    public FigTextView(Context context) {
        super(context);
    }

    public FigTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        new ImageAttributes.Builder().setContext(context).setAttributeSet(attrs).setAttrStyleable(R.styleable.FigTextView).setSrcStyleable(R.styleable.FigTextView_src).setIconSizeStyleable(R.styleable.FigTextView_iconSize).setIconPaddingStyleable(R.styleable.FigTextView_iconPadding).setIconTintStyleable(R.styleable.FigTextView_iconTint).setIconMarginEndStyleable(R.styleable.FigTextView_iconTextGap).build().set(this.mIcon);
        new TextAttributes.Builder().setContext(context).setAttributeSet(attrs).setAttrStyleable(R.styleable.FigTextView).setTextStyleable(R.styleable.FigTextView_text).setTextColorStyleable(R.styleable.FigTextView_textColor).setTextSizeStyleable(R.styleable.FigTextView_textSize).setTextStyleStyleable(R.styleable.FigTextView_textStyle).build().set(this.mLabel);
    }

    public FigTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public FigTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void init() {
        this.setContentLayout(R.layout.fig_button);
        this.setOrientation(0);
        this.mIcon = (ImageView)this.findViewById(R.id.icon);
        this.mLabel = (TextView)this.findViewById(R.id.label);
    }

    public void setIcon(Drawable drawable) {
        this.mIcon.setImageDrawable(drawable);
    }

    public void setIconResource(@DrawableRes Integer drawableRes) {
        this.mIcon.setImageResource(drawableRes.intValue());
    }

    public void setIconTint(@ColorRes Integer colorRes) {
        this.mIcon.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
    }

    public void setIconPadding(@DimenRes Integer dimenRes) {
        int padding = (int)this.getContext().getResources().getDimension(dimenRes.intValue());
        this.mIcon.setPadding(padding, padding, padding, padding);
    }

    public void setLabel(String label) {
        this.mLabel.setText((CharSequence)label);
    }

    public void setLabel(@StringRes Integer labelRes) {
        this.mLabel.setText(labelRes.intValue());
    }

    public void setLabelColor(@ColorRes Integer textColorRes) {
        this.mLabel.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)textColorRes));
    }

    public void setLabelSize(@DimenRes Integer dimenRes) {
        int labelSize = (int)this.getContext().getResources().getDimension(dimenRes.intValue());
        this.mLabel.setTextSize((float)labelSize);
    }
}

