/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.server;

import android.content.Context;
import androidx.annotation.Nullable;
import com.android.volley.VolleyError;
import com.github.bijoysingh.starter.server.QueryExecutor;
import com.github.bijoysingh.starter.server.QueryParams;
import com.github.bijoysingh.starter.util.FileManager;
import java.util.Map;
import org.json.JSONObject;

public class DefaultQueryExecutor
extends QueryExecutor {
    protected Integer timeout;
    protected Integer maxRetries;
    protected float retryBackoffMultiplier;
    protected OnQueryListener onQueryListener;
    protected AuthenticationProvider authenticationProvider;

    private DefaultQueryExecutor(Context context, Integer timeout, Integer maxRetries, float retryBackoffMultiplier, @Nullable OnQueryListener onQueryListener, @Nullable AuthenticationProvider authenticationProvider) {
        super(context);
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        this.retryBackoffMultiplier = retryBackoffMultiplier;
        this.onQueryListener = onQueryListener;
        this.authenticationProvider = authenticationProvider;
    }

    @Override
    protected void handleGetResponse(QueryParams queryParams, String response) {
        if (queryParams.getCache() != null && !queryParams.getCache().isEmpty()) {
            FileManager.write(this.context, queryParams.getCache(), response);
        }
        if (this.onQueryListener != null) {
            this.onQueryListener.onSuccess(queryParams, response);
        }
    }

    @Override
    protected void handleSendResponse(QueryParams queryParams, JSONObject response) {
        if (queryParams.getCache() != null && !queryParams.getCache().isEmpty()) {
            FileManager.write(this.context, queryParams.getCache(), response.toString());
        }
        if (this.onQueryListener != null) {
            this.onQueryListener.onSuccess(queryParams, response.toString());
        }
    }

    @Override
    protected void handleGetError(QueryParams queryParams, VolleyError error) {
        if (this.onQueryListener != null) {
            this.onQueryListener.onFail(queryParams, error);
        }
    }

    @Override
    protected void handleSendError(QueryParams queryParams, VolleyError error) {
        if (this.onQueryListener != null) {
            this.onQueryListener.onFail(queryParams, error);
        }
    }

    @Override
    protected Map<String, String> getAuthenticationData() {
        if (this.authenticationProvider == null) {
            return super.getAuthenticationData();
        }
        return this.authenticationProvider.getAuthenticationData();
    }

    @Override
    protected float getBackoffMultiplier() {
        return this.retryBackoffMultiplier;
    }

    @Override
    protected Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    protected Integer getTimeoutMillis() {
        return this.timeout;
    }

    public static class Builder {
        private Context context;
        private Integer timeout;
        private Integer maxRetries;
        private float retryBackoffMultiplier;
        private OnQueryListener onQueryListener;
        private AuthenticationProvider authenticationProvider;

        public Builder(Context context) {
            this.context = context;
            this.timeout = 2500;
            this.maxRetries = 1;
            this.retryBackoffMultiplier = 1.0f;
        }

        public Builder setTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder setRetryBackoffMultiplier(float retryBackoffMultiplier) {
            this.retryBackoffMultiplier = retryBackoffMultiplier;
            return this;
        }

        public Builder setOnQueryListener(OnQueryListener onQueryListener) {
            this.onQueryListener = onQueryListener;
            return this;
        }

        public Builder setAuthenticationProvider(AuthenticationProvider provider) {
            this.authenticationProvider = provider;
            return this;
        }

        public DefaultQueryExecutor build() {
            return new DefaultQueryExecutor(this.context, this.timeout, this.maxRetries, this.retryBackoffMultiplier, this.onQueryListener, this.authenticationProvider);
        }
    }

    public static interface AuthenticationProvider {
        public Map<String, String> getAuthenticationData();
    }

    public static interface OnQueryListener {
        public void onSuccess(QueryParams var1, String var2);

        public void onFail(QueryParams var1, VolleyError var2);
    }
}

