/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.prefs;

import android.content.Context;
import com.github.bijoysingh.starter.prefs.Store;

public class VersionedStore
extends Store {
    private static final String STORE_VERSION_KEY = "__store_version__";
    private final int mVersionNumber;
    private final Migration mMigration;

    private VersionedStore(Context context, String storeName, int versionNumber, Migration migration) {
        super(context, storeName);
        this.mVersionNumber = versionNumber;
        this.mMigration = migration;
    }

    public static VersionedStore get(Context context, String storeName, int versionNumber) {
        return VersionedStore.get(context, storeName, versionNumber, null);
    }

    public static VersionedStore get(Context context, String storeName, int versionNumber, Migration migration) {
        Store store;
        if (versionNumber <= 0) {
            throw new IllegalArgumentException("Version should not be negative");
        }
        if (sStores.containsKey(storeName)) {
            store = (Store)sStores.get(storeName);
            if (store instanceof VersionedStore) {
                VersionedStore versionedStore = (VersionedStore)store;
                if (versionedStore.mVersionNumber == versionNumber) {
                    return versionedStore;
                }
            }
            store.destroy();
        }
        store = new VersionedStore(context, storeName, versionNumber, migration);
        store.initialise();
        sStores.put(storeName, store);
        return store;
    }

    @Override
    protected void onReadCompleted() {
        super.onReadCompleted();
        int versionKey = this.get(STORE_VERSION_KEY, 0);
        if (versionKey == 0) {
            this.put(STORE_VERSION_KEY, this.mVersionNumber);
            return;
        }
        if (versionKey >= this.mVersionNumber) {
            return;
        }
        if (this.mMigration == null) {
            this.put(STORE_VERSION_KEY, this.mVersionNumber);
            return;
        }
        for (int startIndex = versionKey; startIndex < this.mVersionNumber; ++startIndex) {
            this.mMigration.onMigration(startIndex, startIndex + 1, this);
        }
        this.put(STORE_VERSION_KEY, this.mVersionNumber);
    }

    public static interface Migration {
        public void onMigration(int var1, int var2, VersionedStore var3);
    }
}

