/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.recyclerview;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.github.bijoysingh.starter.recyclerview.MultiRecyclerViewControllerItem;
import com.github.bijoysingh.starter.recyclerview.RecyclerViewHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MultiRecyclerViewAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    protected Map<Integer, MultiRecyclerViewControllerItem<T>> controller;
    protected Context context;
    protected List<T> contents;
    protected boolean isClickEnabled;
    protected Bundle extra;
    protected RecyclerView.LayoutManager layoutManager;

    public MultiRecyclerViewAdapter(Context context, List<MultiRecyclerViewControllerItem<T>> controllerItemList) {
        this.context = context;
        this.contents = new ArrayList<T>();
        this.isClickEnabled = false;
        this.controller = new HashMap<Integer, MultiRecyclerViewControllerItem<T>>();
        for (MultiRecyclerViewControllerItem<T> item : controllerItemList) {
            this.controller.put(item.getViewType(), item);
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        MultiRecyclerViewControllerItem<T> item = this.controller.get(viewType);
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(item.getLayoutFile().intValue(), parent, false);
        try {
            return item.getHolderClass().getConstructor(Context.class, View.class).newInstance(this.context, v);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        Class<RecyclerViewHolder<T>> classToCast = this.controller.get(this.getItemViewType(position)).getHolderClass();
        final RecyclerViewHolder<T> castedHolder = classToCast.cast(holder);
        final T data = this.getItems().get(position);
        if (this.isClickEnabled) {
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MultiRecyclerViewAdapter.this.onItemClick(castedHolder, data);
                }
            });
        }
        castedHolder.populate(data, this.extra);
    }

    public int getItemCount() {
        return this.getItems().size();
    }

    public LinearLayoutManager getLinearLayoutManager() {
        if (this.layoutManager == null || !(this.layoutManager instanceof LinearLayoutManager)) {
            this.layoutManager = new LinearLayoutManager(this.context);
        }
        return (LinearLayoutManager)this.layoutManager;
    }

    public GridLayoutManager getGridLayoutManager(int columns) {
        if (this.layoutManager == null || !(this.layoutManager instanceof GridLayoutManager)) {
            this.layoutManager = new GridLayoutManager(this.context, columns);
        }
        ((GridLayoutManager)this.layoutManager).setSpanSizeLookup(this.getSpanSizeLookup());
        return (GridLayoutManager)this.layoutManager;
    }

    protected GridLayoutManager.SpanSizeLookup getSpanSizeLookup() {
        return new GridLayoutManager.SpanSizeLookup(){

            public int getSpanSize(int position) {
                int viewType = MultiRecyclerViewAdapter.this.getItemViewType(position);
                return MultiRecyclerViewAdapter.this.controller.get(viewType).getSpanSize();
            }
        };
    }

    public abstract int getItemViewType(int var1);

    public void setClickEnabled(boolean clickEnabled) {
        this.isClickEnabled = clickEnabled;
    }

    public void setExtra(Bundle extra) {
        this.extra = extra;
    }

    public void onItemClick(RecyclerViewHolder<T> holder, T item) {
    }

    public List<T> getItems() {
        return this.contents;
    }

    public void setItems(List<T> list) {
        this.contents = list;
        this.notifyDataSetChanged();
    }

    public void addItem(T item, int position) {
        this.contents.add(position, item);
        this.notifyItemInserted(position);
    }

    public void updateItem(T item, int position) {
        this.contents.remove(position);
        this.contents.add(position, item);
        this.notifyItemChanged(position);
    }

    public void addItem(T item) {
        this.contents.add(item);
        this.notifyItemInserted(this.contents.size() - 1);
    }

    public void addItems(List<T> items) {
        this.contents.addAll(items);
        this.notifyItemRangeInserted(this.contents.size() - items.size() - 1, items.size());
    }

    public void removeItem(T item) {
        int position = this.contents.indexOf(item);
        if (position != -1) {
            this.removeItem(position);
        }
    }

    public void clearItems() {
        this.contents.clear();
        this.notifyDataSetChanged();
    }

    public void removeItem(int position) {
        this.contents.remove(position);
        this.notifyItemRemoved(position);
    }
}

