/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.database;

import android.content.ContentValues;
import android.util.Log;
import com.github.bijoysingh.starter.database.DBColumn;
import com.github.bijoysingh.starter.database.DatabaseColumn;
import com.github.bijoysingh.starter.database.DatabaseException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public abstract class DatabaseModel {
    List<DatabaseColumn> keys = null;

    public String getTableName() {
        return this.getClass().getName().replace(".", "_");
    }

    public List<DatabaseColumn> getKeys() {
        this.setKeys();
        return this.keys;
    }

    public DatabaseColumn getGeneratePrimaryKey() {
        return new DatabaseColumn("primary_key", DBColumn.Type.INTEGER, true, true, false);
    }

    public DatabaseException.ErrorResponse isValid(List<DatabaseColumn> keys) {
        Boolean hasPrimary = false;
        for (DatabaseColumn key : keys) {
            if (key.primaryKey.booleanValue() && hasPrimary.booleanValue()) {
                return DatabaseException.ErrorResponse.MULTIPLE_PRIMARY_KEYS;
            }
            if (key.primaryKey.booleanValue() && key.autoIncrement.booleanValue() && !key.fieldType.equals((Object)DBColumn.Type.INTEGER)) {
                return DatabaseException.ErrorResponse.NON_INTEGER_AUTO_INCREMENT_PRIMARY_KEY;
            }
            if (key.primaryKey.booleanValue()) {
                hasPrimary = true;
                continue;
            }
            if (!key.autoIncrement.booleanValue()) continue;
            return DatabaseException.ErrorResponse.AUTO_INCREMENT_NOT_PRIMARY;
        }
        return DatabaseException.ErrorResponse.OK;
    }

    public Boolean hasPrimaryKey(List<DatabaseColumn> keys) {
        for (DatabaseColumn key : keys) {
            if (!key.primaryKey.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public String createTable() throws DatabaseException {
        this.setKeys();
        DatabaseException.ErrorResponse validity = this.isValid(this.keys);
        if (!validity.equals((Object)DatabaseException.ErrorResponse.OK)) {
            throw new DatabaseException(validity.toString());
        }
        if (!this.hasPrimaryKey(this.keys).booleanValue()) {
            this.keys.add(this.getGeneratePrimaryKey());
        }
        String sql = "CREATE TABLE " + this.getTableName() + "(";
        Integer position = 0;
        for (DatabaseColumn key : this.keys) {
            sql = sql + key.getCreateQuery();
            Integer n = position;
            Integer n2 = position = Integer.valueOf(position + 1);
            if (position.intValue() == this.keys.size()) continue;
            sql = sql + ",";
        }
        sql = sql + ");";
        return sql;
    }

    public void setKeys() {
        Field[] fields;
        if (this.keys != null) {
            return;
        }
        this.keys = new ArrayList<DatabaseColumn>();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            DBColumn annotation = field.getAnnotation(DBColumn.class);
            if (annotation == null) continue;
            DatabaseColumn column = new DatabaseColumn(annotation);
            column.fieldName = annotation.fieldName().isEmpty() ? field.getName() : annotation.fieldName();
            column.fieldType = annotation.fieldType().equals((Object)DBColumn.Type.DEFAULT) ? DatabaseColumn.getType(field.getType()) : annotation.fieldType();
            column.field = field;
            this.keys.add(column);
        }
    }

    public ContentValues getValues() {
        this.setKeys();
        ContentValues values = new ContentValues();
        for (DatabaseColumn column : this.keys) {
            column.field.setAccessible(true);
            try {
                if (column.fieldType.equals((Object)DBColumn.Type.INTEGER)) {
                    values.put(column.fieldName, (Integer)column.field.get(this));
                    continue;
                }
                if (column.fieldType.equals((Object)DBColumn.Type.TEXT)) {
                    values.put(column.fieldName, (String)column.field.get(this));
                    continue;
                }
                values.put(column.fieldName, (Double)column.field.get(this));
            }
            catch (IllegalAccessException exception) {
                Log.e((String)DatabaseModel.class.getSimpleName(), (String)exception.getMessage(), (Throwable)exception);
            }
        }
        return values;
    }
}

