/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.prefs;

import android.content.Context;
import android.util.Log;
import com.github.bijoysingh.starter.util.FileManager;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageManager {
    private Context context;
    private JSONObject data;

    public StorageManager(Context context) {
        this.context = context;
        this.refresh();
    }

    protected String getFilename() {
        return "StorageManager." + this.context.getPackageName() + ".txt";
    }

    public boolean has(String key) {
        return this.data.has(key);
    }

    public void put(String key, boolean value) {
        this.putSafe(key, value);
    }

    public void put(String key, int value) {
        this.putSafe(key, value);
    }

    public void put(String key, String value) {
        this.putSafe(key, value);
    }

    public void put(String key, double value) {
        this.putSafe(key, value);
    }

    public void put(String key, float value) {
        this.putSafe(key, Float.valueOf(value));
    }

    public void put(String key, long value) {
        this.putSafe(key, value);
    }

    public boolean get(String key, boolean defaultValue) {
        try {
            return this.data.getBoolean(key);
        }
        catch (JSONException exception) {
            return defaultValue;
        }
    }

    public int get(String key, int defaultValue) {
        try {
            return this.data.getInt(key);
        }
        catch (JSONException exception) {
            return defaultValue;
        }
    }

    public String get(String key, String defaultValue) {
        try {
            return this.data.getString(key);
        }
        catch (JSONException exception) {
            return defaultValue;
        }
    }

    public double get(String key, double defaultValue) {
        try {
            return this.data.getDouble(key);
        }
        catch (JSONException exception) {
            return defaultValue;
        }
    }

    public float get(String key, float defaultValue) {
        try {
            return (float)this.data.getDouble(key);
        }
        catch (JSONException exception) {
            return defaultValue;
        }
    }

    public long get(String key, long defaultValue) {
        try {
            return this.data.getLong(key);
        }
        catch (JSONException exception) {
            return defaultValue;
        }
    }

    private void putSafe(String key, Object value) {
        try {
            this.data.put(key, value);
            this.write();
        }
        catch (JSONException exception) {
            Log.e((String)StorageManager.class.getSimpleName(), (String)"Put Failed", (Throwable)exception);
        }
    }

    public StorageManager refresh() {
        String content = FileManager.read(this.context, this.getFilename());
        try {
            this.data = new JSONObject(content);
        }
        catch (JSONException exception) {
            this.data = new JSONObject();
        }
        return this;
    }

    private void write() {
        FileManager.write(this.context, this.getFilename(), this.data.toString());
    }
}

