/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.recyclerview;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class RecyclerViewBuilder {
    private Context context;
    private LinearLayoutManager layoutManager;
    private OnScrollListener onScrollListener;
    private RecyclerView.Adapter adapter;
    private RecyclerView recyclerView;

    public RecyclerViewBuilder(Context context) {
        this.context = context;
    }

    public RecyclerViewBuilder setView(View root, Integer recyclerViewId) {
        this.recyclerView = (RecyclerView)root.findViewById(recyclerViewId.intValue());
        return this;
    }

    public RecyclerViewBuilder setView(Activity activity, Integer recyclerViewId) {
        this.recyclerView = (RecyclerView)activity.findViewById(recyclerViewId.intValue());
        return this;
    }

    public RecyclerViewBuilder setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        return this;
    }

    public RecyclerViewBuilder setLinear() {
        this.layoutManager = new LinearLayoutManager(this.context);
        return this;
    }

    public RecyclerViewBuilder setOnScrollListener(OnScrollListener scrollListener) {
        if (this.layoutManager == null) {
            this.setLinear();
        }
        this.onScrollListener = scrollListener;
        return this;
    }

    public RecyclerViewBuilder setAdapter(RecyclerView.Adapter adapter) {
        this.adapter = adapter;
        return this;
    }

    public RecyclerView build() {
        if (this.recyclerView == null) {
            throw new IllegalArgumentException("Cannot instantiate with null view");
        }
        if (this.layoutManager == null) {
            this.setLinear();
        }
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        if (this.adapter != null) {
            this.recyclerView.setAdapter(this.adapter);
        }
        this.recyclerView.setHasFixedSize(false);
        if (this.onScrollListener != null) {
            this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    if (dy > 0) {
                        Integer visibleItemCount = RecyclerViewBuilder.this.layoutManager.getChildCount();
                        Integer totalItemCount = RecyclerViewBuilder.this.layoutManager.getItemCount();
                        Integer pastVisiblesItems = RecyclerViewBuilder.this.layoutManager.findFirstVisibleItemPosition();
                        if (visibleItemCount + pastVisiblesItems >= totalItemCount) {
                            RecyclerViewBuilder.this.onScrollListener.onScrollToBottom(recyclerView);
                        }
                    }
                }
            });
        }
        return this.recyclerView;
    }

    public static interface OnScrollListener {
        public void onScrollToBottom(RecyclerView var1);
    }
}

