/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.recyclerview;

import com.github.bijoysingh.starter.recyclerview.RecyclerViewHolder;

public class MultiRecyclerViewControllerItem<T> {
    public static final int DEFAULT_VIEW_TYPE = 0;
    public static final int DEFAULT_SPAN_SIZE = 1;
    private Integer viewType = null;
    private Integer spanSize = null;
    private Integer layoutFile = null;
    private Class<RecyclerViewHolder<T>> holderClass = null;

    private MultiRecyclerViewControllerItem(Builder builder) {
        this.viewType = builder.viewType;
        this.spanSize = builder.spanSize;
        this.layoutFile = builder.layoutFile;
        this.holderClass = builder.holderClass;
    }

    public Integer getViewType() {
        return this.viewType;
    }

    public Integer getSpanSize() {
        return this.spanSize;
    }

    public Integer getLayoutFile() {
        return this.layoutFile;
    }

    public Class<RecyclerViewHolder<T>> getHolderClass() {
        return this.holderClass;
    }

    public static final class Builder<T> {
        private Integer viewType = 0;
        private Integer spanSize = 1;
        private Integer layoutFile;
        private Class<RecyclerViewHolder<T>> holderClass;

        public Builder viewType(Integer val) {
            this.viewType = val;
            return this;
        }

        public Builder spanSize(Integer val) {
            this.spanSize = val;
            return this;
        }

        public Builder layoutFile(Integer val) {
            this.layoutFile = val;
            return this;
        }

        public Builder holderClass(Class<RecyclerViewHolder<T>> val) {
            this.holderClass = val;
            return this;
        }

        public MultiRecyclerViewControllerItem build() {
            if (this.layoutFile == null || this.holderClass == null || this.viewType == null) {
                throw new IllegalArgumentException("Layout file cannot be null");
            }
            return new MultiRecyclerViewControllerItem(this);
        }
    }
}

