/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.json;

import android.util.Log;
import com.github.bijoysingh.starter.json.JsonField;
import com.github.bijoysingh.starter.json.JsonFieldItem;
import com.github.bijoysingh.starter.json.JsonModelException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JsonModel {
    List<JsonFieldItem> fields;

    public JsonModel() {
    }

    public JsonModel(String response) throws Exception {
        this(new JSONObject(response));
    }

    public JsonModel(JSONObject json) throws Exception {
        this.setFields();
        for (JsonFieldItem field : this.fields) {
            if (field.isArray.booleanValue()) continue;
            try {
                if (field.type.equals((Object)JsonField.Type.INTEGER)) {
                    field.field.set(this, json.getInt(field.fieldName));
                    continue;
                }
                if (field.type.equals((Object)JsonField.Type.REAL)) {
                    field.field.set(this, json.getDouble(field.fieldName));
                    continue;
                }
                if (field.type.equals((Object)JsonField.Type.BOOLEAN)) {
                    field.field.set(this, json.getBoolean(field.fieldName));
                    continue;
                }
                if (field.type.equals((Object)JsonField.Type.STRING)) {
                    field.field.set(this, json.getString(field.fieldName));
                    continue;
                }
                if (field.type.equals((Object)JsonField.Type.JSON)) {
                    field.field.set(this, json.getJSONObject(field.fieldName));
                    continue;
                }
                if (!field.type.equals((Object)JsonField.Type.JSON_MODEL)) continue;
                field.field.set(this, field.jsonField.getConstructor(JSONObject.class).newInstance(json.getJSONObject(field.fieldName)));
            }
            catch (JSONException exception) {
                if (field.optional.booleanValue()) {
                    Log.e((String)JsonModel.class.getSimpleName(), (String)exception.getMessage(), (Throwable)exception);
                    continue;
                }
                throw exception;
            }
        }
    }

    public JSONObject serialize() throws Exception {
        this.setFields();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (JsonFieldItem field : this.fields) {
            if (field.isArray.booleanValue()) continue;
            if (field.type.equals((Object)JsonField.Type.JSON_MODEL)) {
                values.put(field.fieldName, ((JsonModel)field.field.get(this)).serialize());
                continue;
            }
            values.put(field.fieldName, field.field.get(this));
        }
        return new JSONObject(values);
    }

    public void setFields() throws JsonModelException {
        Field[] classFields;
        if (this.fields != null) {
            return;
        }
        this.fields = new ArrayList<JsonFieldItem>();
        for (Field field : classFields = this.getClass().getDeclaredFields()) {
            JsonField annotation = field.getAnnotation(JsonField.class);
            if (annotation == null) continue;
            JsonFieldItem item = new JsonFieldItem(annotation);
            item.fieldName = annotation.field().isEmpty() ? field.getName() : annotation.field();
            JsonField.Type type = item.type = annotation.type().equals((Object)JsonField.Type.AUTO) ? JsonFieldItem.getType(field.getType()) : annotation.type();
            if (item.type == JsonField.Type.AUTO) {
                throw new JsonModelException(JsonModelException.ErrorResponse.UNKNOWN_AUTO.toString());
            }
            item.field = field;
            if (item.type.equals((Object)JsonField.Type.JSON_MODEL) && !JsonModel.class.isAssignableFrom(field.getType())) {
                throw new JsonModelException(JsonModelException.ErrorResponse.JSON_FIELD_WRONG_CLASS.toString());
            }
            this.fields.add(item);
        }
    }
}

