/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.util;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import java.util.ArrayList;

public class PermissionManager {
    public static final Integer REQUEST_CODE_ASK_PERMISSIONS = 1201;
    private Activity activity;
    private String[] permissions;

    public PermissionManager(Activity activity) {
        this.activity = activity;
        this.permissions = new String[0];
    }

    public PermissionManager(Activity activity, String[] permissions) {
        this.activity = activity;
        this.permissions = permissions;
    }

    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
    }

    public Boolean hasPermission(String permission) {
        return ContextCompat.checkSelfPermission((Context)this.activity, (String)permission) == 0;
    }

    public String[] getMissingPermissions() {
        ArrayList<String> missingPermissions = new ArrayList<String>();
        for (String permission : this.permissions) {
            if (this.hasPermission(permission).booleanValue()) continue;
            missingPermissions.add(permission);
        }
        String[] missingPermissionsArray = new String[missingPermissions.size()];
        missingPermissions.toArray(missingPermissionsArray);
        return missingPermissionsArray;
    }

    public Boolean hasAllPermissions() {
        String[] missingPermissions = this.getMissingPermissions();
        return missingPermissions.length == 0;
    }

    public void requestPermissions() {
        if (Build.VERSION.SDK_INT >= 23 && !this.hasAllPermissions().booleanValue()) {
            this.activity.requestPermissions(this.getMissingPermissions(), REQUEST_CODE_ASK_PERMISSIONS.intValue());
        }
    }
}

