/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.prefs;

import android.content.Context;
import android.content.SharedPreferences;

public abstract class PreferenceManager {
    public Context context;

    public PreferenceManager(Context context) {
        this.context = context;
    }

    public String getPreferencesFolder() {
        return this.context.getPackageName().replace(".", "_");
    }

    public String load(String key) {
        return this.load(key, "");
    }

    public String load(String key, String defaultString) {
        SharedPreferences sp = this.context.getSharedPreferences(this.getPreferencesFolder(), 0);
        return sp.getString(key, defaultString);
    }

    public void save(String key, String value) {
        SharedPreferences sp = this.context.getSharedPreferences(this.getPreferencesFolder(), 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public void save(String key, Boolean bool) {
        SharedPreferences sp = this.context.getSharedPreferences(this.getPreferencesFolder(), 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean(key, bool.booleanValue());
        editor.apply();
    }

    public void save(String key, Integer integer) {
        SharedPreferences sp = this.context.getSharedPreferences(this.getPreferencesFolder(), 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt(key, integer.intValue());
        editor.apply();
    }

    public Boolean load(String key, Boolean defaultBool) {
        SharedPreferences sp = this.context.getSharedPreferences(this.getPreferencesFolder(), 0);
        return sp.getBoolean(key, defaultBool.booleanValue());
    }

    public Integer load(String key, Integer defaultInteger) {
        SharedPreferences sp = this.context.getSharedPreferences(this.getPreferencesFolder(), 0);
        return sp.getInt(key, defaultInteger.intValue());
    }
}

