/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.server;

import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.github.bijoysingh.starter.server.QueryParams;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public abstract class QueryExecutor {
    protected Context context;

    protected QueryExecutor(Context context) {
        this.context = context;
    }

    protected JsonObjectRequest getJsonRequest(final QueryParams access, Map<String, Object> map) {
        JsonObjectRequest jsonRequest = new JsonObjectRequest(access.getMethod(), access.getUrl(), new JSONObject(map), (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject json) {
                QueryExecutor.this.handleSendResponse(access, json);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                QueryExecutor.this.handleSendError(access, error);
            }
        }){

            public Map<String, String> getHeaders() throws AuthFailureError {
                HashMap<String, String> params = new HashMap<String, String>();
                if (access.getAuthenticated().booleanValue()) {
                    params.putAll(QueryExecutor.this.getAuthenticationData());
                }
                return params;
            }
        };
        jsonRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(this.getTimeoutMillis().intValue(), this.getMaxRetries().intValue(), this.getBackoffMultiplier()));
        return jsonRequest;
    }

    protected StringRequest getStringRequest(final QueryParams access) {
        StringRequest request = new StringRequest(0, access.getUrl(), (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                QueryExecutor.this.handleGetResponse(access, response);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                QueryExecutor.this.handleGetError(access, error);
            }
        }){

            public Map<String, String> getHeaders() throws AuthFailureError {
                HashMap<String, String> params = new HashMap<String, String>();
                if (access.getAuthenticated().booleanValue()) {
                    params.putAll(QueryExecutor.this.getAuthenticationData());
                }
                return params;
            }
        };
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(this.getTimeoutMillis().intValue(), 0, 1.0f));
        return request;
    }

    protected Integer getTimeoutMillis() {
        return 2500;
    }

    protected Integer getMaxRetries() {
        return 0;
    }

    protected float getBackoffMultiplier() {
        return 1.0f;
    }

    public void get(QueryParams access) {
        StringRequest request = this.getStringRequest(access);
        Volley.newRequestQueue((Context)this.context).add((Request)request);
    }

    public void send(QueryParams access, Map<String, Object> map) {
        JsonObjectRequest request = this.getJsonRequest(access, map);
        Volley.newRequestQueue((Context)this.context).add((Request)request);
    }

    protected Map<String, String> getAuthenticationData() {
        return new HashMap<String, String>();
    }

    protected abstract void handleGetResponse(QueryParams var1, String var2);

    protected abstract void handleSendResponse(QueryParams var1, JSONObject var2);

    protected abstract void handleGetError(QueryParams var1, VolleyError var2);

    protected abstract void handleSendError(QueryParams var1, VolleyError var2);
}

