/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.recyclerview;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class RVBuilder {
    private Context context;
    private View root;
    private LinearLayoutManager layoutManager;
    private OnScrollListener onScrollListener;
    private RecyclerView.Adapter adapter;
    private Integer recyclerViewId;
    private RecyclerView recyclerView;

    public RVBuilder(Context context) {
        this.context = context;
    }

    public RVBuilder setView(View root, Integer recyclerViewId) {
        this.root = root;
        this.recyclerViewId = recyclerViewId;
        return this;
    }

    public RVBuilder setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        return this;
    }

    public RVBuilder setLinear() {
        this.layoutManager = new LinearLayoutManager(this.context);
        return this;
    }

    public RVBuilder setOnScrollListener(OnScrollListener scrollListener) {
        if (this.layoutManager == null) {
            this.setLinear();
        }
        this.onScrollListener = scrollListener;
        return this;
    }

    public RVBuilder setAdapter(RecyclerView.Adapter adapter) {
        this.adapter = adapter;
        return this;
    }

    public RecyclerView build() {
        if ((this.root == null || this.recyclerViewId == null) && this.recyclerView == null) {
            throw new IllegalArgumentException("Cannot instantiate with null view");
        }
        if (this.layoutManager == null) {
            this.setLinear();
        }
        this.recyclerView = this.recyclerView == null ? (RecyclerView)this.root.findViewById(this.recyclerViewId.intValue()) : this.recyclerView;
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        if (this.adapter != null) {
            this.recyclerView.setAdapter(this.adapter);
        }
        this.recyclerView.setHasFixedSize(false);
        if (this.onScrollListener != null) {
            this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    if (dy > 0) {
                        Integer visibleItemCount = RVBuilder.this.layoutManager.getChildCount();
                        Integer totalItemCount = RVBuilder.this.layoutManager.getItemCount();
                        Integer pastVisiblesItems = RVBuilder.this.layoutManager.findFirstVisibleItemPosition();
                        if (visibleItemCount + pastVisiblesItems >= totalItemCount) {
                            RVBuilder.this.onScrollListener.onScrollToBottom(recyclerView);
                        }
                    }
                }
            });
        }
        return this.recyclerView;
    }

    public static interface OnScrollListener {
        public void onScrollToBottom(RecyclerView var1);
    }
}

