/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.snia.keyvalue;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.math.BigInteger;
import java.util.Set;
import java.util.stream.Stream;

public final class ObjectStoreTraceReader
extends TextTraceReader {
    public ObjectStoreTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public Set<Policy.Characteristic> characteristics() {
        return Sets.immutableEnumSet((Enum)Policy.Characteristic.WEIGHTED, (Enum[])new Policy.Characteristic[0]);
    }

    @Override
    public Stream<AccessEvent> events() {
        return this.lines().map(line -> line.split(" ")).filter(array -> array[1].equals("REST.GET.OBJECT")).map(array -> {
            int weight;
            long key = new BigInteger(array[2], 16).longValue();
            if (((String[])array).length == 3) {
                weight = Integer.parseInt(array[3]);
            } else {
                long start = Long.parseLong(array[4]);
                long end = Long.parseLong(array[5]);
                weight = Ints.saturatedCast((long)(end - start));
            }
            return AccessEvent.forKeyAndWeight(key, weight);
        });
    }
}

