/*
 * Decompiled with CFR 0.152.
 */
package com.beeline09.daterangepicker.date;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import com.beeline09.daterangepicker.date.DateRangePickerController;
import com.beeline09.daterangepicker.date.MonthView;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b&\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0002./B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H&J\b\u0010\u0017\u001a\u00020\tH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\tH\u0016J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020!H\u0017J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0004J\u0018\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0002J\u001c\u0010)\u001a\u00020%2\b\u0010*\u001a\u0004\u0018\u00010\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010+\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u000e\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\tR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u00060"}, d2={"Lcom/beeline09/daterangepicker/date/MonthAdapter;", "Landroid/widget/BaseAdapter;", "Lcom/beeline09/daterangepicker/date/MonthView$OnDayClickListener;", "mContext", "Landroid/content/Context;", "mController", "Lcom/beeline09/daterangepicker/date/DateRangePickerController;", "(Landroid/content/Context;Lcom/beeline09/daterangepicker/date/DateRangePickerController;)V", "mAccentColor", "", "getMController", "()Lcom/beeline09/daterangepicker/date/DateRangePickerController;", "mSelectedDay", "Lcom/beeline09/daterangepicker/date/MonthAdapter$CalendarDay;", "day", "selectedDay", "getSelectedDay", "()Lcom/beeline09/daterangepicker/date/MonthAdapter$CalendarDay;", "setSelectedDay", "(Lcom/beeline09/daterangepicker/date/MonthAdapter$CalendarDay;)V", "createMonthView", "Lcom/beeline09/daterangepicker/date/MonthView;", "context", "getCount", "getItem", "", "position", "getItemId", "", "getView", "Landroid/view/View;", "convertView", "parent", "Landroid/view/ViewGroup;", "hasStableIds", "", "init", "", "isSelectedDayInMonth", "year", "month", "onDayClick", "view", "onDayTapped", "setAccentColor", "color", "CalendarDay", "Companion", "daterangepicker_release"})
public abstract class MonthAdapter
extends BaseAdapter
implements MonthView.OnDayClickListener {
    private CalendarDay mSelectedDay;
    private int mAccentColor;
    private final Context mContext;
    @Nullable
    private final DateRangePickerController mController;
    private static final String TAG = "SimpleMonthAdapter";
    private static int WEEK_7_OVERHANG_HEIGHT;
    private static final int MONTHS_IN_YEAR = 12;
    public static final Companion Companion;

    @Nullable
    public final CalendarDay getSelectedDay() {
        return this.mSelectedDay;
    }

    public final void setSelectedDay(@Nullable CalendarDay day) {
        this.mSelectedDay = day;
        this.notifyDataSetChanged();
    }

    public final void setAccentColor(int color2) {
        this.mAccentColor = color2;
    }

    protected final void init() {
        this.mSelectedDay = new CalendarDay(System.currentTimeMillis());
    }

    public int getCount() {
        return this.mController != null ? (this.mController.getMaxYear() - this.mController.getMinSelectableYear() + 1) * MONTHS_IN_YEAR : 0;
    }

    @Nullable
    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public boolean hasStableIds() {
        return true;
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    public View getView(int position, @Nullable View convertView, @NotNull ViewGroup parent) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        MonthView v = null;
        HashMap<String, Integer> drawingParams = null;
        if (convertView != null) {
            v = (MonthView)convertView;
            Object object = v.getTag();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.HashMap<kotlin.String, kotlin.Int>");
            }
            drawingParams = (HashMap)object;
        } else {
            v = this.createMonthView(this.mContext);
            AbsListView.LayoutParams params = new AbsListView.LayoutParams(-1, -1);
            v.setLayoutParams((ViewGroup.LayoutParams)params);
            v.setClickable(true);
            v.setOnDayClickListener(this);
            if (this.mAccentColor != -1) {
                v.setAccentColor(this.mAccentColor);
            }
        }
        if (drawingParams == null) {
            drawingParams = new HashMap<String, Integer>();
        }
        drawingParams.clear();
        int month = position % MONTHS_IN_YEAR;
        DateRangePickerController dateRangePickerController = this.mController;
        int year = position / MONTHS_IN_YEAR + (dateRangePickerController != null ? dateRangePickerController.getMinSelectableYear() : 0);
        int selectedDay = -1;
        if (this.isSelectedDayInMonth(year, month)) {
            CalendarDay calendarDay = this.mSelectedDay;
            if (calendarDay == null) {
                Intrinsics.throwNpe();
            }
            selectedDay = calendarDay.getDay();
        }
        v.reuse();
        ((Map)drawingParams).put(MonthView.Companion.getVIEW_PARAMS_SELECTED_DAY(), selectedDay);
        ((Map)drawingParams).put(MonthView.Companion.getVIEW_PARAMS_YEAR(), year);
        ((Map)drawingParams).put(MonthView.Companion.getVIEW_PARAMS_MONTH(), month);
        DateRangePickerController dateRangePickerController2 = this.mController;
        ((Map)drawingParams).put(MonthView.Companion.getVIEW_PARAMS_WEEK_START(), dateRangePickerController2 != null ? dateRangePickerController2.getFirstDayOfWeek() : 0);
        v.setMonthParams(drawingParams);
        v.invalidate();
        return v;
    }

    @NotNull
    public abstract MonthView createMonthView(@NotNull Context var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSelectedDayInMonth(int year, int month) {
        CalendarDay calendarDay = this.mSelectedDay;
        if (calendarDay == null) {
            Intrinsics.throwNpe();
        }
        if (calendarDay.getYear() != year) return false;
        CalendarDay calendarDay2 = this.mSelectedDay;
        if (calendarDay2 == null) {
            Intrinsics.throwNpe();
        }
        if (calendarDay2.getMonth() != month) return false;
        return true;
    }

    @Override
    public void onDayClick(@Nullable MonthView view, @Nullable CalendarDay day) {
        if (day != null) {
            this.onDayTapped(day);
        }
    }

    private final void onDayTapped(CalendarDay day) {
        DateRangePickerController dateRangePickerController = this.mController;
        if (dateRangePickerController != null) {
            dateRangePickerController.tryVibrate();
        }
        DateRangePickerController dateRangePickerController2 = this.mController;
        if (dateRangePickerController2 != null) {
            dateRangePickerController2.onDayOfMonthSelected(day.getYear(), day.getMonth(), day.getDay());
        }
        this.setSelectedDay(day);
    }

    @Nullable
    protected final DateRangePickerController getMController() {
        return this.mController;
    }

    public MonthAdapter(@NotNull Context mContext, @Nullable DateRangePickerController mController) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        this.mController = mController;
        this.mAccentColor = -1;
        this.init();
        DateRangePickerController dateRangePickerController = this.mController;
        this.setSelectedDay(dateRangePickerController != null ? dateRangePickerController.getSelectedDay() : null);
    }

    static {
        Companion = new Companion(null);
        TAG = TAG;
        WEEK_7_OVERHANG_HEIGHT = 7;
        MONTHS_IN_YEAR = 12;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000J\u001e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R$\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/beeline09/daterangepicker/date/MonthAdapter$CalendarDay;", "", "()V", "timeInMillis", "", "(J)V", "calendar", "Ljava/util/Calendar;", "(Ljava/util/Calendar;)V", "year", "", "month", "day", "(III)V", "<set-?>", "getDay", "()I", "setDay$daterangepicker_release", "(I)V", "getMonth", "setMonth$daterangepicker_release", "getYear", "setYear$daterangepicker_release", "set", "", "date", "setDay", "setTime", "daterangepicker_release"})
    public static final class CalendarDay {
        private Calendar calendar;
        private int year;
        private int month;
        private int day;

        public final int getYear() {
            return this.year;
        }

        public final void setYear$daterangepicker_release(int n) {
            this.year = n;
        }

        public final int getMonth() {
            return this.month;
        }

        public final void setMonth$daterangepicker_release(int n) {
            this.month = n;
        }

        public final int getDay() {
            return this.day;
        }

        public final void setDay$daterangepicker_release(int n) {
            this.day = n;
        }

        public final void set(@NotNull CalendarDay date) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            this.year = date.year;
            this.month = date.month;
            this.day = date.day;
        }

        public final void setDay(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        private final void setTime(long timeInMillis) {
            if (this.calendar == null) {
                this.calendar = Calendar.getInstance();
            }
            Calendar calendar = this.calendar;
            if (calendar == null) {
                Intrinsics.throwNpe();
            }
            calendar.setTimeInMillis(timeInMillis);
            Calendar calendar2 = this.calendar;
            if (calendar2 == null) {
                Intrinsics.throwNpe();
            }
            this.month = calendar2.get(2);
            Calendar calendar3 = this.calendar;
            if (calendar3 == null) {
                Intrinsics.throwNpe();
            }
            this.year = calendar3.get(1);
            Calendar calendar4 = this.calendar;
            if (calendar4 == null) {
                Intrinsics.throwNpe();
            }
            this.day = calendar4.get(5);
        }

        public CalendarDay() {
            this.setTime(System.currentTimeMillis());
        }

        public CalendarDay(long timeInMillis) {
            this.setTime(timeInMillis);
        }

        public CalendarDay(@NotNull Calendar calendar) {
            Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
            this.year = calendar.get(1);
            this.month = calendar.get(2);
            this.day = calendar.get(5);
        }

        public CalendarDay(int year, int month, int day) {
            this.setDay(year, month, day);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/beeline09/daterangepicker/date/MonthAdapter$Companion;", "", "()V", "MONTHS_IN_YEAR", "", "getMONTHS_IN_YEAR", "()I", "TAG", "", "WEEK_7_OVERHANG_HEIGHT", "getWEEK_7_OVERHANG_HEIGHT", "setWEEK_7_OVERHANG_HEIGHT", "(I)V", "daterangepicker_release"})
    public static final class Companion {
        protected final int getWEEK_7_OVERHANG_HEIGHT() {
            return WEEK_7_OVERHANG_HEIGHT;
        }

        protected final void setWEEK_7_OVERHANG_HEIGHT(int n) {
            WEEK_7_OVERHANG_HEIGHT = n;
        }

        public final int getMONTHS_IN_YEAR() {
            return MONTHS_IN_YEAR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

