/*
 * Decompiled with CFR 0.152.
 */
package com.beeline09.daterangepicker;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.SystemClock;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.provider.Settings;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/beeline09/daterangepicker/HapticFeedbackController;", "", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mContentObserver", "Landroid/database/ContentObserver;", "mIsGloballyEnabled", "", "mLastVibrate", "", "mVibrator", "Landroid/os/Vibrator;", "hasVibratePermission", "context", "start", "", "stop", "tryVibrate", "Companion", "daterangepicker_release"})
public final class HapticFeedbackController {
    private final ContentObserver mContentObserver;
    private Vibrator mVibrator;
    private boolean mIsGloballyEnabled;
    private long mLastVibrate;
    private final Context mContext;
    private static final int VIBRATE_DELAY_MS = 125;
    private static final int VIBRATE_LENGTH_MS = 50;
    public static final Companion Companion = new Companion(null);

    public final void start() {
        if (this.hasVibratePermission(this.mContext)) {
            Object object = this.mContext.getSystemService("vibrator");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.os.Vibrator");
            }
            this.mVibrator = (Vibrator)object;
        }
        this.mIsGloballyEnabled = HapticFeedbackController.Companion.checkGlobalSetting(this.mContext);
        Uri uri = Settings.System.getUriFor((String)"haptic_feedback_enabled");
        this.mContext.getContentResolver().registerContentObserver(uri, false, this.mContentObserver);
    }

    private final boolean hasVibratePermission(Context context) {
        PackageManager pm = context.getPackageManager();
        int hasPerm = pm.checkPermission("android.permission.VIBRATE", context.getPackageName());
        return hasPerm == 0;
    }

    public final void stop() {
        this.mVibrator = null;
        this.mContext.getContentResolver().unregisterContentObserver(this.mContentObserver);
    }

    public final void tryVibrate() {
        long now;
        if (this.mVibrator != null && this.mIsGloballyEnabled && (now = SystemClock.uptimeMillis()) - this.mLastVibrate >= (long)VIBRATE_DELAY_MS) {
            if (Build.VERSION.SDK_INT >= 26) {
                Vibrator vibrator = this.mVibrator;
                if (vibrator == null) {
                    Intrinsics.throwNpe();
                }
                vibrator.vibrate(VibrationEffect.createOneShot((long)VIBRATE_LENGTH_MS, (int)-1));
            } else {
                Vibrator vibrator = this.mVibrator;
                if (vibrator == null) {
                    Intrinsics.throwNpe();
                }
                vibrator.vibrate((long)VIBRATE_LENGTH_MS);
            }
            this.mLastVibrate = now;
        }
    }

    public HapticFeedbackController(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        this.mContentObserver = new ContentObserver(null){

            public void onChange(boolean selfChange) {
                mIsGloballyEnabled = Companion.checkGlobalSetting(mContext);
            }
        };
    }

    static {
        VIBRATE_DELAY_MS = 125;
        VIBRATE_LENGTH_MS = 50;
    }

    public static final /* synthetic */ boolean access$getMIsGloballyEnabled$p(HapticFeedbackController $this) {
        return $this.mIsGloballyEnabled;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/beeline09/daterangepicker/HapticFeedbackController$Companion;", "", "()V", "VIBRATE_DELAY_MS", "", "VIBRATE_LENGTH_MS", "checkGlobalSetting", "", "context", "Landroid/content/Context;", "daterangepicker_release"})
    public static final class Companion {
        private final boolean checkGlobalSetting(Context context) {
            return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"haptic_feedback_enabled", (int)0) == 1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

