/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewpager;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.github.barteksc.pdfviewpager.R;
import com.github.barteksc.pdfviewpager.adapter.PDFPagerAdapter;
import fr.castorflex.android.verticalviewpager.VerticalViewPager;

public class PDFViewPager
extends VerticalViewPager {
    protected Context context;
    protected float pageScale = 1.0f;

    public PDFViewPager(Context context, String pdfPath) {
        super(context);
        this.context = context;
        this.init(pdfPath);
    }

    public PDFViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init(attrs);
    }

    protected void init(String pdfPath) {
        this.initAdapter(this.context, pdfPath, 1.0f);
    }

    protected void init(AttributeSet attrs) {
        if (this.isInEditMode()) {
            this.setBackgroundResource(R.drawable.flaticon_pdf_dummy);
            return;
        }
        if (attrs != null) {
            TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.PDFViewPager);
            String assetFileName = a.getString(R.styleable.PDFViewPager_assetFileName);
            float scale = a.getFloat(R.styleable.PDFViewPager_pageBitmapScale, 1.0f);
            if (assetFileName != null && assetFileName.length() > 0) {
                this.initAdapter(this.context, assetFileName, scale);
            }
            a.recycle();
        }
    }

    protected void initAdapter(Context context, String pdfPath, float pageScale) {
        this.setAdapter(new PDFPagerAdapter(context, pdfPath, pageScale));
    }

    public float getPageBitmapScale() {
        float sc = this.pageScale;
        if (this.getAdapter() != null) {
            sc = ((PDFPagerAdapter)this.getAdapter()).getPageBitmapScale();
        }
        return sc;
    }

    public void setPageBitmapScale(float scale) {
        this.pageScale = scale;
        if (this.getAdapter() != null) {
            ((PDFPagerAdapter)this.getAdapter()).setPageBitmapScale(scale);
        }
    }
}

