/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewpager.async;

import android.content.Context;
import android.os.AsyncTask;
import com.github.barteksc.pdfviewpager.PDFViewPager;
import com.github.barteksc.pdfviewpager.adapter.PDFPagerAdapterZoom;
import com.github.barteksc.pdfviewpager.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class PdfOpenAsyncTask
extends AsyncTask<Void, Void, Void> {
    private PDFPagerAdapterZoom pagerAdapterZoom;
    private PDFViewPager pdfViewPager;
    private boolean isAsset;
    private Context context;
    private String path;
    private OnPdfLoadListener listener;

    public PdfOpenAsyncTask(PDFViewPager pdfViewPager, String path) {
        this(pdfViewPager, path, false);
    }

    public PdfOpenAsyncTask(PDFViewPager pdfViewPager, String path, boolean isAsset) {
        this.pdfViewPager = pdfViewPager;
        this.context = pdfViewPager.getContext();
        this.path = path;
        this.isAsset = isAsset;
    }

    public PdfOpenAsyncTask setOnPdfLoadListener(OnPdfLoadListener listener) {
        this.listener = listener;
        return this;
    }

    protected Void doInBackground(Void ... params) {
        try {
            if (this.isAsset) {
                FileUtil.copyAsset(this.context, this.path, new File(this.context.getCacheDir(), this.path).getAbsolutePath());
            }
            this.pagerAdapterZoom = new PDFPagerAdapterZoom(this.context, this.path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void onPostExecute(Void result) {
        this.pdfViewPager.setAdapter(this.pagerAdapterZoom);
        if (this.listener != null) {
            this.listener.onPdfLoaded();
        }
    }

    protected void onCancelled() {
        if (this.pagerAdapterZoom != null) {
            this.pagerAdapterZoom.close();
        }
    }

    public static interface OnPdfLoadListener {
        public void onPdfLoaded();
    }
}

