/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewpager.async;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.widget.ImageView;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

public class PdfRenderPageAsyncTask
extends AsyncTask<Void, Void, Void> {
    private static final int MAX_DIMENSION = 1800;
    private WeakReference<ImageView> imageViewRef;
    private Bitmap bitmap;
    private PdfiumCore pdfiumCore;
    private PdfDocument pdfDocument;
    private int position;
    private OnPdfPageRenderListener listener;

    public PdfRenderPageAsyncTask(ImageView imageView, int position, PdfiumCore pdfiumCore, PdfDocument pdfDocument) {
        this.imageViewRef = new WeakReference<ImageView>(imageView);
        this.position = position;
        this.pdfiumCore = pdfiumCore;
        this.pdfDocument = pdfDocument;
    }

    protected Void doInBackground(Void ... params) {
        float aspectRatio;
        this.pdfiumCore.openPage(this.pdfDocument, this.position);
        int width = this.pdfiumCore.getPageWidth(this.pdfDocument, this.position);
        int height = this.pdfiumCore.getPageHeight(this.pdfDocument, this.position);
        if (width > height && width > 1800) {
            aspectRatio = (float)width / (float)height;
            width = 1800;
            height = Math.round((float)width / aspectRatio);
        } else if (height > 1800) {
            aspectRatio = (float)height / (float)width;
            height = 1800;
            width = Math.round((float)height / aspectRatio);
        }
        Bitmap pageBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.pdfiumCore.renderPageBitmap(this.pdfDocument, pageBitmap, this.position, 0, 0, width, height);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        pageBitmap.compress(Bitmap.CompressFormat.JPEG, 95, (OutputStream)out);
        pageBitmap.recycle();
        BitmapFactory.Options ops = new BitmapFactory.Options();
        ops.inJustDecodeBounds = false;
        byte[] arr = out.toByteArray();
        this.bitmap = BitmapFactory.decodeByteArray((byte[])arr, (int)0, (int)arr.length, (BitmapFactory.Options)ops);
        return null;
    }

    protected void onPostExecute(Void o) {
        if (this.imageViewRef.get() != null) {
            ((ImageView)this.imageViewRef.get()).setImageBitmap(this.bitmap);
            if (this.listener != null) {
                this.listener.onPageRendered(this.position, (ImageView)this.imageViewRef.get(), this.bitmap);
            }
        }
    }

    public void onCancelled(Void result) {
        if (this.bitmap != null) {
            this.bitmap.recycle();
            this.bitmap = null;
        }
    }

    public PdfRenderPageAsyncTask setOnPdfPageRenderListener(OnPdfPageRenderListener listener) {
        this.listener = listener;
        return this;
    }

    public static interface OnPdfPageRenderListener {
        public void onPageRendered(int var1, ImageView var2, Bitmap var3);
    }
}

