/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.graphics.PointF;
import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.github.barteksc.pdfviewer.AnimationManager;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.PdfFile;
import com.github.barteksc.pdfviewer.model.LinkTapEvent;
import com.github.barteksc.pdfviewer.scroll.ScrollHandle;
import com.github.barteksc.pdfviewer.util.Constants;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.util.SizeF;

class DragPinchManager
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
ScaleGestureDetector.OnScaleGestureListener,
View.OnTouchListener {
    private PDFView pdfView;
    private AnimationManager animationManager;
    private GestureDetector gestureDetector;
    private ScaleGestureDetector scaleGestureDetector;
    private boolean scrolling = false;
    private boolean scaling = false;
    private boolean enabled = false;

    DragPinchManager(PDFView pdfView, AnimationManager animationManager) {
        this.pdfView = pdfView;
        this.animationManager = animationManager;
        this.gestureDetector = new GestureDetector(pdfView.getContext(), (GestureDetector.OnGestureListener)this);
        this.scaleGestureDetector = new ScaleGestureDetector(pdfView.getContext(), (ScaleGestureDetector.OnScaleGestureListener)this);
        pdfView.setOnTouchListener(this);
    }

    void enable() {
        this.enabled = true;
    }

    void disable() {
        this.enabled = false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        ScrollHandle ps;
        boolean onTapHandled = this.pdfView.callbacks.callOnTap(e);
        boolean linkTapped = this.checkLinkTapped(e.getX(), e.getY());
        if (!(onTapHandled || linkTapped || (ps = this.pdfView.getScrollHandle()) == null || this.pdfView.documentFitsView())) {
            if (!ps.shown()) {
                ps.show();
            } else {
                ps.hide();
            }
        }
        this.pdfView.performClick();
        return true;
    }

    private boolean checkLinkTapped(float x, float y) {
        int pageY;
        int pageX;
        PdfFile pdfFile = this.pdfView.pdfFile;
        float mappedX = -this.pdfView.getCurrentXOffset() + x;
        float mappedY = -this.pdfView.getCurrentYOffset() + y;
        int page = pdfFile.getPageAtOffset(this.pdfView.isSwipeVertical() ? mappedY : mappedX, this.pdfView.getZoom());
        SizeF pageSize = pdfFile.getScaledPageSize(page, this.pdfView.getZoom());
        if (this.pdfView.isSwipeVertical()) {
            pageX = (int)this.getSecondaryOffset(pageSize);
            pageY = (int)pdfFile.getPageOffset(page, this.pdfView.getZoom());
        } else {
            pageY = (int)this.getSecondaryOffset(pageSize);
            pageX = (int)pdfFile.getPageOffset(page, this.pdfView.getZoom());
        }
        for (PdfDocument.Link link : pdfFile.getPageLinks(page)) {
            RectF mapped = pdfFile.mapRectToDevice(page, pageX, pageY, (int)pageSize.getWidth(), (int)pageSize.getHeight(), link.getBounds());
            if (!mapped.contains(mappedX, mappedY)) continue;
            this.pdfView.callbacks.callLinkHandler(new LinkTapEvent(x, y, mappedX, mappedY, mapped, link));
            return true;
        }
        return false;
    }

    private float getSecondaryOffset(SizeF pageSize) {
        if (this.pdfView.isSwipeVertical()) {
            float maxWidth = this.pdfView.pdfFile.getMaxPageWidth();
            return (this.pdfView.toCurrentScale(maxWidth) - pageSize.getWidth()) / 2.0f;
        }
        float maxHeight = this.pdfView.pdfFile.getMaxPageHeight();
        return (this.pdfView.toCurrentScale(maxHeight) - pageSize.getHeight()) / 2.0f;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (!this.pdfView.isDoubletapEnabled()) {
            return false;
        }
        if (this.pdfView.getZoom() < this.pdfView.getMidZoom()) {
            this.pdfView.zoomWithAnimation(e.getX(), e.getY(), this.pdfView.getMidZoom());
        } else if (this.pdfView.getZoom() < this.pdfView.getMaxZoom()) {
            this.pdfView.zoomWithAnimation(e.getX(), e.getY(), this.pdfView.getMaxZoom());
        } else {
            this.pdfView.resetZoomWithAnimation();
        }
        return true;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        return false;
    }

    public boolean onDown(MotionEvent e) {
        this.animationManager.stopFling();
        return true;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.scrolling = true;
        if (this.pdfView.isZooming() || this.pdfView.isSwipeEnabled()) {
            this.pdfView.moveRelativeTo(-distanceX, -distanceY);
        }
        if (!this.scaling || this.pdfView.doRenderDuringScale()) {
            this.pdfView.loadPageByOffset();
        }
        return true;
    }

    private void onScrollEnd(MotionEvent event) {
        this.pdfView.loadPages();
        this.hideHandle();
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        float minY;
        float minX;
        if (!this.pdfView.isSwipeEnabled()) {
            return false;
        }
        int xOffset = (int)this.pdfView.getCurrentXOffset();
        int yOffset = (int)this.pdfView.getCurrentYOffset();
        PdfFile pdfFile = this.pdfView.pdfFile;
        if (this.pdfView.isSwipeVertical()) {
            minX = -(this.pdfView.toCurrentScale(pdfFile.getMaxPageWidth()) - (float)this.pdfView.getWidth());
            minY = -(pdfFile.getDocLen(this.pdfView.getZoom()) - (float)this.pdfView.getHeight());
        } else {
            minX = -(pdfFile.getDocLen(this.pdfView.getZoom()) - (float)this.pdfView.getWidth());
            minY = -(this.pdfView.toCurrentScale(pdfFile.getMaxPageHeight()) - (float)this.pdfView.getHeight());
        }
        this.animationManager.startFlingAnimation(xOffset, yOffset, (int)velocityX, (int)velocityY, (int)minX, 0, (int)minY, 0);
        return true;
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float dr = detector.getScaleFactor();
        float wantedZoom = this.pdfView.getZoom() * dr;
        if (wantedZoom < Constants.Pinch.MINIMUM_ZOOM) {
            dr = Constants.Pinch.MINIMUM_ZOOM / this.pdfView.getZoom();
        } else if (wantedZoom > Constants.Pinch.MAXIMUM_ZOOM) {
            dr = Constants.Pinch.MAXIMUM_ZOOM / this.pdfView.getZoom();
        }
        this.pdfView.zoomCenteredRelativeTo(dr, new PointF(detector.getFocusX(), detector.getFocusY()));
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        this.scaling = true;
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        this.pdfView.loadPages();
        this.hideHandle();
        this.scaling = false;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (!this.enabled) {
            return false;
        }
        boolean retVal = this.scaleGestureDetector.onTouchEvent(event);
        boolean bl = retVal = this.gestureDetector.onTouchEvent(event) || retVal;
        if (event.getAction() == 1 && this.scrolling) {
            this.scrolling = false;
            this.onScrollEnd(event);
        }
        return retVal;
    }

    private void hideHandle() {
        ScrollHandle scrollHandle = this.pdfView.getScrollHandle();
        if (scrollHandle != null && scrollHandle.shown()) {
            scrollHandle.hideDelayed();
        }
    }
}

