/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.content.Context;
import android.os.AsyncTask;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.source.DocumentSource;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;

class DecodingAsyncTask
extends AsyncTask<Void, Void, Throwable> {
    private boolean cancelled;
    private PDFView pdfView;
    private Context context;
    private PdfiumCore pdfiumCore;
    private PdfDocument pdfDocument;
    private String password;
    private DocumentSource docSource;
    private int firstPageIdx;
    private int pageWidth;
    private int pageHeight;

    DecodingAsyncTask(DocumentSource docSource, String password, PDFView pdfView, PdfiumCore pdfiumCore, int firstPageIdx) {
        this.docSource = docSource;
        this.firstPageIdx = firstPageIdx;
        this.cancelled = false;
        this.pdfView = pdfView;
        this.password = password;
        this.pdfiumCore = pdfiumCore;
        this.context = pdfView.getContext();
    }

    protected Throwable doInBackground(Void ... params) {
        try {
            this.pdfDocument = this.docSource.createDocument(this.context, this.pdfiumCore, this.password);
            this.pdfiumCore.openPage(this.pdfDocument, this.firstPageIdx);
            this.pageWidth = this.pdfiumCore.getPageWidth(this.pdfDocument, this.firstPageIdx);
            this.pageHeight = this.pdfiumCore.getPageHeight(this.pdfDocument, this.firstPageIdx);
            return null;
        }
        catch (Throwable t) {
            return t;
        }
    }

    protected void onPostExecute(Throwable t) {
        if (t != null) {
            this.pdfView.loadError(t);
            return;
        }
        if (!this.cancelled) {
            this.pdfView.loadComplete(this.pdfDocument, this.pageWidth, this.pageHeight);
        }
    }

    protected void onCancelled() {
        this.cancelled = true;
    }
}

