/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.graphics.RectF;
import android.util.Pair;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.util.Constants;
import com.github.barteksc.pdfviewer.util.MathUtils;

class PagesLoader {
    private PDFView pdfView;
    private int cacheOrder;
    private float scaledHeight;
    private float scaledWidth;
    private Pair<Integer, Integer> colsRows;
    private float xOffset;
    private float yOffset;
    private float rowHeight;
    private float colWidth;
    private float pageRelativePartWidth;
    private float pageRelativePartHeight;
    private float partRenderWidth;
    private float partRenderHeight;
    private int thumbnailWidth;
    private int thumbnailHeight;
    private final RectF thumbnailRect = new RectF(0.0f, 0.0f, 1.0f, 1.0f);

    public PagesLoader(PDFView pdfView) {
        this.pdfView = pdfView;
    }

    private Pair<Integer, Integer> getPageColsRows() {
        float ratioX = 1.0f / this.pdfView.getOptimalPageWidth();
        float ratioY = 1.0f / this.pdfView.getOptimalPageHeight();
        float partHeight = 256.0f * ratioY / this.pdfView.getZoom();
        float partWidth = 256.0f * ratioX / this.pdfView.getZoom();
        int nbRows = MathUtils.ceil(1.0f / partHeight);
        int nbCols = MathUtils.ceil(1.0f / partWidth);
        return new Pair((Object)nbCols, (Object)nbRows);
    }

    private int documentPage(int userPage) {
        int documentPage = userPage;
        if (this.pdfView.getFilteredUserPages() != null) {
            if (userPage < 0 || userPage >= this.pdfView.getFilteredUserPages().length) {
                return -1;
            }
            documentPage = this.pdfView.getFilteredUserPages()[userPage];
        }
        if (documentPage < 0 || userPage >= this.pdfView.getDocumentPageCount()) {
            return -1;
        }
        return documentPage;
    }

    private Holder getPageAndCoordsByOffset(float offset) {
        Holder holder = new Holder();
        float fixOffset = -MathUtils.max(offset, 0.0f);
        if (this.pdfView.isSwipeVertical()) {
            holder.page = MathUtils.floor(fixOffset / this.scaledHeight);
            holder.row = MathUtils.floor(Math.abs(fixOffset - this.scaledHeight * (float)holder.page) / this.rowHeight);
            holder.col = MathUtils.floor(this.xOffset / this.colWidth);
        } else {
            holder.page = MathUtils.floor(fixOffset / this.scaledWidth);
            holder.col = MathUtils.floor(Math.abs(fixOffset - this.scaledWidth * (float)holder.page) / this.colWidth);
            holder.row = MathUtils.floor(this.yOffset / this.rowHeight);
        }
        return holder;
    }

    private void loadThumbnail(int userPage, int documentPage) {
        if (!this.pdfView.cacheManager.containsThumbnail(userPage, documentPage, this.thumbnailWidth, this.thumbnailHeight, this.thumbnailRect)) {
            this.pdfView.renderingHandler.addRenderingTask(userPage, documentPage, this.thumbnailWidth, this.thumbnailHeight, this.thumbnailRect, true, 0, this.pdfView.isBestQuality(), this.pdfView.isAnnotationRendering());
        }
    }

    private int loadRelative(int number, int nbOfPartsLoadable, boolean outsideView) {
        float newOffset;
        int loaded = 0;
        if (this.pdfView.isSwipeVertical()) {
            float rowsHeight = this.rowHeight * (float)number + 1.0f;
            newOffset = this.pdfView.getCurrentYOffset() - (float)(outsideView ? this.pdfView.getHeight() : 0) - rowsHeight;
        } else {
            float colsWidth = this.colWidth * (float)number;
            newOffset = this.pdfView.getCurrentXOffset() - (float)(outsideView ? this.pdfView.getWidth() : 0) - colsWidth;
        }
        Holder holder = this.getPageAndCoordsByOffset(newOffset);
        int documentPage = this.documentPage(holder.page);
        if (documentPage < 0) {
            return 0;
        }
        this.loadThumbnail(holder.page, documentPage);
        if (this.pdfView.isSwipeVertical()) {
            int firstCol = MathUtils.floor(this.xOffset / this.colWidth);
            firstCol = MathUtils.min(firstCol - 1, 0);
            int lastCol = MathUtils.ceil((this.xOffset + (float)this.pdfView.getWidth()) / this.colWidth);
            lastCol = MathUtils.max(lastCol + 1, (Integer)this.colsRows.first);
            for (int col = firstCol; col <= lastCol; ++col) {
                if (this.loadCell(holder.page, documentPage, holder.row, col, this.pageRelativePartWidth, this.pageRelativePartHeight)) {
                    ++loaded;
                }
                if (loaded < nbOfPartsLoadable) continue;
                return loaded;
            }
        } else {
            int firstRow = MathUtils.floor(this.yOffset / this.rowHeight);
            firstRow = MathUtils.min(firstRow - 1, 0);
            int lastRow = MathUtils.ceil((this.yOffset + (float)this.pdfView.getHeight()) / this.rowHeight);
            lastRow = MathUtils.max(lastRow + 1, (Integer)this.colsRows.second);
            for (int row = firstRow; row <= lastRow; ++row) {
                if (this.loadCell(holder.page, documentPage, row, holder.col, this.pageRelativePartWidth, this.pageRelativePartHeight)) {
                    ++loaded;
                }
                if (loaded < nbOfPartsLoadable) continue;
                return loaded;
            }
        }
        return loaded;
    }

    public int loadVisible() {
        int nextDocPage;
        int prevDocPage;
        int i;
        int page;
        Holder firstHolder;
        int parts = 0;
        if (this.pdfView.isSwipeVertical()) {
            firstHolder = this.getPageAndCoordsByOffset(this.pdfView.getCurrentYOffset());
            Holder lastHolder = this.getPageAndCoordsByOffset(this.pdfView.getCurrentYOffset() - (float)this.pdfView.getHeight() + 1.0f);
            int visibleRows = 0;
            if (firstHolder.page == lastHolder.page) {
                visibleRows = lastHolder.row - firstHolder.row + 1;
            } else {
                visibleRows += (Integer)this.colsRows.second - firstHolder.row;
                for (page = firstHolder.page + 1; page < lastHolder.page; ++page) {
                    visibleRows += ((Integer)this.colsRows.second).intValue();
                }
                visibleRows += lastHolder.row + 1;
            }
            for (i = 0; i < visibleRows && parts < Constants.Cache.CACHE_SIZE; parts += this.loadRelative(i, Constants.Cache.CACHE_SIZE - parts, false), ++i) {
            }
        } else {
            firstHolder = this.getPageAndCoordsByOffset(this.pdfView.getCurrentXOffset());
            Holder lastHolder = this.getPageAndCoordsByOffset(this.pdfView.getCurrentXOffset() - (float)this.pdfView.getWidth() + 1.0f);
            int visibleCols = 0;
            if (firstHolder.page == lastHolder.page) {
                visibleCols = lastHolder.col - firstHolder.col + 1;
            } else {
                visibleCols += (Integer)this.colsRows.first - firstHolder.col;
                for (page = firstHolder.page + 1; page < lastHolder.page; ++page) {
                    visibleCols += ((Integer)this.colsRows.first).intValue();
                }
                visibleCols += lastHolder.col + 1;
            }
            for (i = 0; i < visibleCols && parts < Constants.Cache.CACHE_SIZE; parts += this.loadRelative(i, Constants.Cache.CACHE_SIZE - parts, false), ++i) {
            }
        }
        if ((prevDocPage = this.documentPage(firstHolder.page - 1)) >= 0) {
            this.loadThumbnail(firstHolder.page - 1, prevDocPage);
        }
        if ((nextDocPage = this.documentPage(firstHolder.page + 1)) >= 0) {
            this.loadThumbnail(firstHolder.page + 1, nextDocPage);
        }
        return parts;
    }

    private boolean loadCell(int userPage, int documentPage, int row, int col, float pageRelativePartWidth, float pageRelativePartHeight) {
        float relX = pageRelativePartWidth * (float)col;
        float relY = pageRelativePartHeight * (float)row;
        float relWidth = pageRelativePartWidth;
        float relHeight = pageRelativePartHeight;
        float renderWidth = this.partRenderWidth;
        float renderHeight = this.partRenderHeight;
        if (relX + relWidth > 1.0f) {
            relWidth = 1.0f - relX;
        }
        if (relY + relHeight > 1.0f) {
            relHeight = 1.0f - relY;
        }
        renderWidth *= relWidth;
        renderHeight *= relHeight;
        RectF pageRelativeBounds = new RectF(relX, relY, relX + relWidth, relY + relHeight);
        if (renderWidth > 0.0f && renderHeight > 0.0f) {
            if (!this.pdfView.cacheManager.upPartIfContained(userPage, documentPage, renderWidth, renderHeight, pageRelativeBounds, this.cacheOrder)) {
                this.pdfView.renderingHandler.addRenderingTask(userPage, documentPage, renderWidth, renderHeight, pageRelativeBounds, false, this.cacheOrder, this.pdfView.isBestQuality(), this.pdfView.isAnnotationRendering());
            }
            ++this.cacheOrder;
            return true;
        }
        return false;
    }

    public void loadPages() {
        this.scaledHeight = this.pdfView.toCurrentScale(this.pdfView.getOptimalPageHeight());
        this.scaledWidth = this.pdfView.toCurrentScale(this.pdfView.getOptimalPageWidth());
        this.thumbnailWidth = (int)(this.pdfView.getOptimalPageWidth() * 0.3f);
        this.thumbnailHeight = (int)(this.pdfView.getOptimalPageHeight() * 0.3f);
        this.colsRows = this.getPageColsRows();
        this.xOffset = -MathUtils.max(this.pdfView.getCurrentXOffset(), 0.0f);
        this.yOffset = -MathUtils.max(this.pdfView.getCurrentYOffset(), 0.0f);
        this.rowHeight = this.scaledHeight / (float)((Integer)this.colsRows.second).intValue();
        this.colWidth = this.scaledWidth / (float)((Integer)this.colsRows.first).intValue();
        this.pageRelativePartWidth = 1.0f / (float)((Integer)this.colsRows.first).intValue();
        this.pageRelativePartHeight = 1.0f / (float)((Integer)this.colsRows.second).intValue();
        this.partRenderWidth = 256.0f / this.pageRelativePartWidth;
        this.partRenderHeight = 256.0f / this.pageRelativePartHeight;
        this.cacheOrder = 1;
        int loaded = this.loadVisible();
        if (this.pdfView.getScrollDir().equals((Object)PDFView.ScrollDir.END)) {
            for (int i = 0; i < 7 && loaded < Constants.Cache.CACHE_SIZE; loaded += this.loadRelative(i, loaded, true), ++i) {
            }
        } else {
            for (int i = 0; i > -7 && loaded < Constants.Cache.CACHE_SIZE; loaded += this.loadRelative(i, loaded, false), --i) {
            }
        }
    }

    private class Holder {
        int page;
        int row;
        int col;

        private Holder() {
        }
    }
}

