/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.github.barteksc.pdfviewer.ScrollBar;
import com.github.barteksc.pdfviewer.util.Util;

public class ScrollBarPageIndicator
extends RelativeLayout {
    private static final int INDICATOR_WIDTH = 75;
    private static final int INDICATOR_HEIGHT = 75;
    private static final int INDICATOR_TEXT_SIZE = 40;
    protected TextView textView;
    protected Context context;
    private ScrollBar scrollBar;

    public ScrollBarPageIndicator(Context context) {
        super(context);
        this.context = context;
        this.textView = new TextView(context);
        this.setVisibility(4);
    }

    public void setSize(int size) {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.getLayoutParams();
        lp.setMargins(0, 0, size + Util.getDP(this.getContext(), 10), 0);
        this.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    void addToScrollBar(ScrollBar scrollBar) {
        int align;
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Util.getDP(this.getContext(), 75), Util.getDP(this.getContext(), 75));
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        int margin = Util.getDP(this.getContext(), 15);
        View parent = (View)scrollBar.getParent();
        if (!scrollBar.isHorizontal()) {
            if (scrollBar.getX() > (float)parent.getWidth() - scrollBar.getX() + (float)scrollBar.getWidth()) {
                right = margin + scrollBar.getWidth();
                align = 7;
            } else {
                left = margin + scrollBar.getWidth();
                align = 5;
            }
        } else if (scrollBar.getY() > (float)parent.getHeight() - scrollBar.getY() + (float)scrollBar.getHeight()) {
            bottom = margin + scrollBar.getHeight();
            align = 8;
        } else {
            top = margin + scrollBar.getHeight();
            align = 6;
        }
        lp.setMargins(left, top, right, bottom);
        lp.addRule(align, scrollBar.getId());
        this.textView.setTextSize(1, 40.0f);
        RelativeLayout.LayoutParams tvlp = new RelativeLayout.LayoutParams(-2, -2);
        tvlp.addRule(13, -1);
        this.addView((View)this.textView, (ViewGroup.LayoutParams)tvlp);
        ((ViewGroup)scrollBar.getParent()).addView((View)this, (ViewGroup.LayoutParams)lp);
        this.scrollBar = scrollBar;
    }

    void setScroll(float pos) {
        if (this.getVisibility() == 0) {
            int viewSize;
            int indicatorSize;
            if (!this.scrollBar.isHorizontal()) {
                indicatorSize = 75;
                viewSize = this.scrollBar.getHeight();
            } else {
                indicatorSize = 75;
                viewSize = this.scrollBar.getWidth();
            }
            pos -= (float)Util.getDP(this.getContext(), indicatorSize / 2) - this.scrollBar.getHandlerHeight() / 2.0f;
            if (pos < 5.0f) {
                pos = 5.0f;
            } else if (pos > (float)(viewSize - Util.getDP(this.getContext(), indicatorSize))) {
                pos = viewSize - Util.getDP(this.getContext(), indicatorSize);
            }
            if (!this.scrollBar.isHorizontal()) {
                this.setY(pos);
            } else {
                this.setX(pos);
            }
        }
    }

    void setPageNum(int page) {
        String text = String.valueOf(page);
        if (!this.textView.getText().equals(text)) {
            this.textView.setText((CharSequence)text);
        }
    }

    void setTextColor(int color) {
        this.textView.setTextColor(color);
    }
}

