/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceView;
import com.github.barteksc.pdfviewer.AnimationManager;
import com.github.barteksc.pdfviewer.CacheManager;
import com.github.barteksc.pdfviewer.DecodingAsyncTask;
import com.github.barteksc.pdfviewer.DragPinchManager;
import com.github.barteksc.pdfviewer.RenderingAsyncTask;
import com.github.barteksc.pdfviewer.ScrollBar;
import com.github.barteksc.pdfviewer.SpiralLoopManager;
import com.github.barteksc.pdfviewer.listener.OnDrawListener;
import com.github.barteksc.pdfviewer.listener.OnErrorListener;
import com.github.barteksc.pdfviewer.listener.OnLoadCompleteListener;
import com.github.barteksc.pdfviewer.listener.OnPageChangeListener;
import com.github.barteksc.pdfviewer.model.PagePart;
import com.github.barteksc.pdfviewer.source.AssetSource;
import com.github.barteksc.pdfviewer.source.ByteArraySource;
import com.github.barteksc.pdfviewer.source.DocumentSource;
import com.github.barteksc.pdfviewer.source.FileSource;
import com.github.barteksc.pdfviewer.source.InputStreamSource;
import com.github.barteksc.pdfviewer.source.UriSource;
import com.github.barteksc.pdfviewer.util.ArrayUtils;
import com.github.barteksc.pdfviewer.util.Constants;
import com.github.barteksc.pdfviewer.util.NumberUtils;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class PDFView
extends SurfaceView {
    private static final String TAG = PDFView.class.getSimpleName();
    public static final float DEFAULT_MAX_SCALE = 3.0f;
    public static final float DEFAULT_MID_SCALE = 1.75f;
    public static final float DEFAULT_MIN_SCALE = 1.0f;
    private float minZoom = 1.0f;
    private float midZoom = 1.75f;
    private float maxZoom = 3.0f;
    private CacheManager cacheManager;
    private AnimationManager animationManager;
    private DragPinchManager dragPinchManager;
    private int[] originalUserPages;
    private int[] filteredUserPages;
    private int[] filteredUserPageIndexes;
    private int documentPageCount;
    private int currentPage;
    private int currentFilteredPage;
    private int pageWidth;
    private int pageHeight;
    private float optimalPageWidth;
    private float optimalPageHeight;
    private float currentXOffset = 0.0f;
    private float currentYOffset = 0.0f;
    private float zoom = 1.0f;
    private RectF leftMask;
    private RectF rightMask;
    private boolean recycled = true;
    private State state = State.DEFAULT;
    private DecodingAsyncTask decodingAsyncTask;
    private RenderingAsyncTask renderingAsyncTask;
    private OnLoadCompleteListener onLoadCompleteListener;
    private OnErrorListener onErrorListener;
    private OnPageChangeListener onPageChangeListener;
    private OnDrawListener onDrawListener;
    private Paint paint;
    private Paint maskPaint;
    private Paint debugPaint;
    private Paint paintMinimapBack;
    private Paint paintMinimapFront;
    private boolean miniMapRequired;
    private RectF minimapBounds;
    private RectF minimapScreenBounds;
    private int defaultPage = 0;
    private boolean userWantsMinimap = false;
    private boolean swipeVertical = false;
    private boolean showPageWithAnimation = true;
    private PdfiumCore pdfiumCore;
    private PdfDocument pdfDocument;
    private ScrollBar scrollBar;
    private boolean bestQuality = false;
    private boolean annotationRendering = false;
    private List<Integer> openedPages = new ArrayList<Integer>();

    public PDFView(Context context, AttributeSet set) {
        super(context, set);
        if (this.isInEditMode()) {
            return;
        }
        this.miniMapRequired = false;
        this.cacheManager = new CacheManager();
        this.animationManager = new AnimationManager(this);
        this.dragPinchManager = new DragPinchManager(this, this.animationManager);
        this.paint = new Paint();
        this.debugPaint = new Paint();
        this.debugPaint.setStyle(Paint.Style.STROKE);
        this.paintMinimapBack = new Paint();
        this.paintMinimapBack.setStyle(Paint.Style.FILL);
        this.paintMinimapBack.setColor(-16777216);
        this.paintMinimapBack.setAlpha(50);
        this.paintMinimapFront = new Paint();
        this.paintMinimapFront.setStyle(Paint.Style.FILL);
        this.paintMinimapFront.setColor(-16777216);
        this.paintMinimapFront.setAlpha(50);
        this.setWillNotDraw(false);
        this.pdfiumCore = new PdfiumCore(context);
    }

    private void load(DocumentSource docSource, String password, OnLoadCompleteListener listener, OnErrorListener onErrorListener) {
        this.load(docSource, password, listener, onErrorListener, null);
    }

    private void load(DocumentSource docSource, String password, OnLoadCompleteListener onLoadCompleteListener, OnErrorListener onErrorListener, int[] userPages) {
        if (!this.recycled) {
            throw new IllegalStateException("Don't call load on a PDF View without recycling it first.");
        }
        if (userPages != null) {
            this.originalUserPages = userPages;
            this.filteredUserPages = ArrayUtils.deleteDuplicatedPages(this.originalUserPages);
            this.filteredUserPageIndexes = ArrayUtils.calculateIndexesInDuplicateArray(this.originalUserPages);
        }
        this.onLoadCompleteListener = onLoadCompleteListener;
        this.onErrorListener = onErrorListener;
        this.recycled = false;
        this.decodingAsyncTask = new DecodingAsyncTask(docSource, password, this, this.pdfiumCore);
        this.decodingAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public void jumpTo(int page) {
        this.showPage(page - 1);
    }

    void showPage(int pageNb) {
        if (this.recycled) {
            return;
        }
        this.state = State.SHOWN;
        this.currentPage = pageNb = this.determineValidPageNumberFrom(pageNb);
        this.currentFilteredPage = pageNb;
        if (this.filteredUserPageIndexes != null && pageNb >= 0 && pageNb < this.filteredUserPageIndexes.length) {
            this.currentFilteredPage = pageNb = this.filteredUserPageIndexes[pageNb];
        }
        this.resetZoom();
        if (this.showPageWithAnimation) {
            if (this.swipeVertical) {
                this.animationManager.startYAnimation(this.currentYOffset, this.calculateCenterOffsetForPage(pageNb));
            } else {
                this.animationManager.startXAnimation(this.currentXOffset, this.calculateCenterOffsetForPage(pageNb));
            }
        } else if (this.swipeVertical) {
            this.moveTo(this.getCurrentXOffset(), this.calculateCenterOffsetForPage(pageNb));
        } else {
            this.moveTo(this.calculateCenterOffsetForPage(pageNb), this.getCurrentYOffset());
        }
        this.loadPages();
        if (this.scrollBar != null) {
            this.scrollBar.pageChanged(this.currentPage);
        }
        if (this.onPageChangeListener != null) {
            this.onPageChangeListener.onPageChanged(this.currentPage + 1, this.getPageCount());
        }
    }

    public int getPageCount() {
        if (this.originalUserPages != null) {
            return this.originalUserPages.length;
        }
        return this.documentPageCount;
    }

    public void enableSwipe(boolean enableSwipe) {
        this.dragPinchManager.setSwipeEnabled(enableSwipe);
    }

    public void enableDoubletap(boolean enableDoubletap) {
        this.dragPinchManager.enableDoubletap(enableDoubletap);
    }

    private void setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.onPageChangeListener = onPageChangeListener;
    }

    OnPageChangeListener getOnPageChangeListener() {
        return this.onPageChangeListener;
    }

    private void setOnDrawListener(OnDrawListener onDrawListener) {
        this.onDrawListener = onDrawListener;
    }

    public void recycle() {
        if (this.renderingAsyncTask != null) {
            this.renderingAsyncTask.cancel(true);
        }
        if (this.decodingAsyncTask != null) {
            this.decodingAsyncTask.cancel(true);
        }
        this.cacheManager.recycle();
        if (this.pdfiumCore != null && this.pdfDocument != null) {
            this.pdfiumCore.closeDocument(this.pdfDocument);
        }
        this.originalUserPages = null;
        this.filteredUserPages = null;
        this.filteredUserPageIndexes = null;
        this.openedPages.clear();
        this.pdfDocument = null;
        this.recycled = true;
        this.state = State.DEFAULT;
    }

    public boolean isRecycled() {
        return this.recycled;
    }

    protected void onDetachedFromWindow() {
        this.recycle();
        super.onDetachedFromWindow();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.isInEditMode()) {
            return;
        }
        this.animationManager.stopAll();
        this.calculateOptimalWidthAndHeight();
        this.loadPages();
        if (this.swipeVertical) {
            this.moveTo(this.currentXOffset, this.calculateCenterOffsetForPage(this.currentFilteredPage));
        } else {
            this.moveTo(this.calculateCenterOffsetForPage(this.currentFilteredPage), this.currentYOffset);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isInEditMode()) {
            return;
        }
        Drawable bg = this.getBackground();
        if (bg == null) {
            canvas.drawColor(-1);
        } else {
            bg.draw(canvas);
        }
        if (this.recycled) {
            return;
        }
        if (this.state != State.SHOWN) {
            return;
        }
        float currentXOffset = this.currentXOffset;
        float currentYOffset = this.currentYOffset;
        canvas.translate(currentXOffset, currentYOffset);
        for (PagePart part : this.cacheManager.getThumbnails()) {
            this.drawPart(canvas, part);
        }
        for (PagePart part : this.cacheManager.getPageParts()) {
            this.drawPart(canvas, part);
        }
        if (this.onDrawListener != null) {
            canvas.translate(this.toCurrentScale((float)this.currentFilteredPage * this.optimalPageWidth), 0.0f);
            this.onDrawListener.onLayerDrawn(canvas, this.toCurrentScale(this.optimalPageWidth), this.toCurrentScale(this.optimalPageHeight), this.currentPage);
            canvas.translate(-this.toCurrentScale((float)this.currentFilteredPage * this.optimalPageWidth), 0.0f);
        }
        canvas.translate(-currentXOffset, -currentYOffset);
        canvas.drawRect(this.leftMask, this.maskPaint);
        canvas.drawRect(this.rightMask, this.maskPaint);
        if (this.userWantsMinimap && this.miniMapRequired) {
            this.drawMiniMap(canvas);
        }
    }

    public void onLayerUpdate() {
        this.invalidate();
    }

    private void drawPart(Canvas canvas, PagePart part) {
        RectF pageRelativeBounds = part.getPageRelativeBounds();
        Bitmap renderedBitmap = part.getRenderedBitmap();
        float localTranslationX = 0.0f;
        float localTranslationY = 0.0f;
        if (this.swipeVertical) {
            localTranslationY = this.toCurrentScale((float)part.getUserPage() * this.optimalPageHeight);
        } else {
            localTranslationX = this.toCurrentScale((float)part.getUserPage() * this.optimalPageWidth);
        }
        canvas.translate(localTranslationX, localTranslationY);
        Rect srcRect = new Rect(0, 0, renderedBitmap.getWidth(), renderedBitmap.getHeight());
        float offsetX = this.toCurrentScale(pageRelativeBounds.left * this.optimalPageWidth);
        float offsetY = this.toCurrentScale(pageRelativeBounds.top * this.optimalPageHeight);
        float width = this.toCurrentScale(pageRelativeBounds.width() * this.optimalPageWidth);
        float height = this.toCurrentScale(pageRelativeBounds.height() * this.optimalPageHeight);
        RectF dstRect = new RectF((float)((int)offsetX), (float)((int)offsetY), (float)((int)(offsetX + width)), (float)((int)(offsetY + height)));
        float translationX = this.currentXOffset + localTranslationX;
        float translationY = this.currentYOffset + localTranslationY;
        if (translationX + dstRect.left >= (float)this.getWidth() || translationX + dstRect.right <= 0.0f || translationY + dstRect.top >= (float)this.getHeight() || translationY + dstRect.bottom <= 0.0f) {
            canvas.translate(-localTranslationX, -localTranslationY);
            return;
        }
        canvas.drawBitmap(renderedBitmap, srcRect, dstRect, this.paint);
        canvas.translate(-localTranslationX, -localTranslationY);
    }

    private void drawMiniMap(Canvas canvas) {
        canvas.drawRect(this.minimapBounds, this.paintMinimapBack);
        canvas.drawRect(this.minimapScreenBounds, this.paintMinimapFront);
    }

    public void loadPages() {
        if (this.optimalPageWidth == 0.0f || this.optimalPageHeight == 0.0f) {
            return;
        }
        this.renderingAsyncTask.removeAllTasks();
        this.cacheManager.makeANewSet();
        int index = this.currentPage;
        if (this.filteredUserPageIndexes != null) {
            index = this.filteredUserPageIndexes[this.currentPage];
        }
        int parts = 0;
        for (int i = 0; i <= 1 && parts < Constants.Cache.CACHE_SIZE; ++i) {
            parts += this.loadPage(index + i, Constants.Cache.CACHE_SIZE - parts);
            if (i == 0 || parts >= Constants.Cache.CACHE_SIZE) continue;
            parts += this.loadPage(index - i, Constants.Cache.CACHE_SIZE - parts);
        }
        this.invalidate();
    }

    private int loadPage(final int userPage, final int nbOfPartsLoadable) {
        float middleOfScreenPageY;
        float middleOfScreenPageX;
        int documentPage = userPage;
        if (this.filteredUserPages != null) {
            if (userPage < 0 || userPage >= this.filteredUserPages.length) {
                return 0;
            }
            documentPage = this.filteredUserPages[userPage];
        }
        final int documentPageFinal = documentPage;
        if (documentPage < 0 || userPage >= this.documentPageCount) {
            return 0;
        }
        if (!this.openedPages.contains(documentPage)) {
            this.openedPages.add(documentPage);
            this.pdfiumCore.openPage(this.pdfDocument, documentPage);
        }
        if (!this.cacheManager.containsThumbnail(userPage, documentPage, (int)(this.optimalPageWidth * 0.3f), (int)(this.optimalPageHeight * 0.3f), new RectF(0.0f, 0.0f, 1.0f, 1.0f))) {
            this.renderingAsyncTask.addRenderingTask(userPage, documentPage, (int)(this.optimalPageWidth * 0.3f), (int)(this.optimalPageHeight * 0.3f), new RectF(0.0f, 0.0f, 1.0f, 1.0f), true, 0, this.bestQuality, this.annotationRendering);
        }
        float ratioX = 1.0f / this.optimalPageWidth;
        float ratioY = 1.0f / this.optimalPageHeight;
        float partHeight = 256.0f * ratioY / this.zoom;
        float partWidth = 256.0f * ratioX / this.zoom;
        int nbRows = (int)Math.ceil(1.0f / partHeight);
        int nbCols = (int)Math.ceil(1.0f / partWidth);
        final float pageRelativePartWidth = 1.0f / (float)nbCols;
        final float pageRelativePartHeight = 1.0f / (float)nbRows;
        float middleOfScreenX = -this.currentXOffset + (float)(this.getWidth() / 2);
        float middleOfScreenY = -this.currentYOffset + (float)(this.getHeight() / 2);
        if (!this.swipeVertical) {
            middleOfScreenPageX = middleOfScreenX - (float)userPage * this.toCurrentScale(this.optimalPageWidth);
            middleOfScreenPageY = middleOfScreenY;
        } else {
            middleOfScreenPageY = middleOfScreenY - (float)userPage * this.toCurrentScale(this.optimalPageHeight);
            middleOfScreenPageX = middleOfScreenX;
        }
        float middleOfScreenPageXRatio = middleOfScreenPageX / this.toCurrentScale(this.optimalPageWidth);
        float middleOfScreenPageYRatio = middleOfScreenPageY / this.toCurrentScale(this.optimalPageHeight);
        int startingRow = (int)(middleOfScreenPageYRatio * (float)nbRows);
        int startingCol = (int)(middleOfScreenPageXRatio * (float)nbCols);
        startingRow = NumberUtils.limit(startingRow, 0, nbRows);
        startingCol = NumberUtils.limit(startingCol, 0, nbCols);
        class SpiralLoopListenerImpl
        implements SpiralLoopManager.SpiralLoopListener {
            int nbItemTreated = 0;

            SpiralLoopListenerImpl() {
            }

            @Override
            public boolean onLoop(int row, int col) {
                float relX = pageRelativePartWidth * (float)col;
                float relY = pageRelativePartHeight * (float)row;
                float relWidth = pageRelativePartWidth;
                float relHeight = pageRelativePartHeight;
                float renderWidth = 256.0f / relWidth;
                float renderHeight = 256.0f / relHeight;
                if (relX + relWidth > 1.0f) {
                    relWidth = 1.0f - relX;
                }
                if (relY + relHeight > 1.0f) {
                    relHeight = 1.0f - relY;
                }
                RectF pageRelativeBounds = new RectF(relX, relY, relX + relWidth, relY + relHeight);
                if ((renderWidth *= relWidth) != 0.0f && (renderHeight *= relHeight) != 0.0f && !PDFView.this.cacheManager.upPartIfContained(userPage, documentPageFinal, renderWidth, renderHeight, pageRelativeBounds, this.nbItemTreated)) {
                    PDFView.this.renderingAsyncTask.addRenderingTask(userPage, documentPageFinal, renderWidth, renderHeight, pageRelativeBounds, false, this.nbItemTreated, PDFView.this.bestQuality, PDFView.this.annotationRendering);
                }
                ++this.nbItemTreated;
                return this.nbItemTreated < nbOfPartsLoadable;
            }
        }
        SpiralLoopListenerImpl spiralLoopListener = new SpiralLoopListenerImpl();
        new SpiralLoopManager(spiralLoopListener).startLoop(nbRows, nbCols, startingRow, startingCol);
        return spiralLoopListener.nbItemTreated;
    }

    public void loadComplete(PdfDocument pdfDocument) {
        this.documentPageCount = this.pdfiumCore.getPageCount(pdfDocument);
        int firstPageIdx = 0;
        if (this.originalUserPages != null) {
            firstPageIdx = this.originalUserPages[0];
        }
        this.pdfDocument = pdfDocument;
        this.pdfiumCore.openPage(pdfDocument, firstPageIdx);
        this.openedPages.add(firstPageIdx);
        this.pageWidth = this.pdfiumCore.getPageWidth(pdfDocument, firstPageIdx);
        this.pageHeight = this.pdfiumCore.getPageHeight(pdfDocument, firstPageIdx);
        this.state = State.LOADED;
        this.calculateOptimalWidthAndHeight();
        this.renderingAsyncTask = new RenderingAsyncTask(this, this.pdfiumCore, pdfDocument);
        this.renderingAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        if (this.scrollBar != null) {
            this.scrollBar.pdfLoaded();
        }
        this.jumpTo(this.defaultPage);
        if (this.onLoadCompleteListener != null) {
            this.onLoadCompleteListener.loadComplete(this.documentPageCount);
        }
    }

    public void loadError(Throwable t) {
        this.recycle();
        this.invalidate();
        if (this.onErrorListener != null) {
            this.onErrorListener.onError(t);
        } else {
            Log.e((String)"PDFView", (String)"load pdf error", (Throwable)t);
        }
    }

    public void onBitmapRendered(PagePart part) {
        if (part.isThumbnail()) {
            this.cacheManager.cacheThumbnail(part);
        } else {
            this.cacheManager.cachePart(part);
        }
        this.invalidate();
    }

    private int determineValidPageNumberFrom(int userPage) {
        if (userPage <= 0) {
            return 0;
        }
        if (this.originalUserPages != null) {
            if (userPage >= this.originalUserPages.length) {
                return this.originalUserPages.length - 1;
            }
        } else if (userPage >= this.documentPageCount) {
            return this.documentPageCount - 1;
        }
        return userPage;
    }

    private float calculateCenterOffsetForPage(int pageNb) {
        if (this.swipeVertical) {
            float imageY = -((float)pageNb * this.optimalPageHeight);
            return imageY += (float)(this.getHeight() / 2) - this.optimalPageHeight / 2.0f;
        }
        float imageX = -((float)pageNb * this.optimalPageWidth);
        return imageX += (float)(this.getWidth() / 2) - this.optimalPageWidth / 2.0f;
    }

    private void calculateOptimalWidthAndHeight() {
        if (this.state == State.DEFAULT || this.getWidth() == 0) {
            return;
        }
        float maxWidth = this.getWidth();
        float maxHeight = this.getHeight();
        float w = this.pageWidth;
        float h = this.pageHeight;
        float ratio = w / h;
        w = maxWidth;
        h = (float)Math.floor(maxWidth / ratio);
        if (h > maxHeight) {
            h = maxHeight;
            w = (float)Math.floor(maxHeight * ratio);
        }
        this.optimalPageWidth = w;
        this.optimalPageHeight = h;
        this.calculateMasksBounds();
        this.calculateMinimapBounds();
    }

    private void calculateMinimapBounds() {
        float ratioX = 200.0f / this.optimalPageWidth;
        float ratioY = 200.0f / this.optimalPageHeight;
        float ratio = Math.min(ratioX, ratioY);
        float minimapWidth = this.optimalPageWidth * ratio;
        float minimapHeight = this.optimalPageHeight * ratio;
        this.minimapBounds = new RectF((float)(this.getWidth() - 5) - minimapWidth, 5.0f, (float)(this.getWidth() - 5), 5.0f + minimapHeight);
        this.calculateMinimapAreaBounds();
    }

    private void calculateMinimapAreaBounds() {
        if (this.minimapBounds == null) {
            return;
        }
        if (this.zoom == 1.0f) {
            this.miniMapRequired = false;
        } else {
            float x = (-this.currentXOffset - this.toCurrentScale((float)this.currentFilteredPage * this.optimalPageWidth)) / this.toCurrentScale(this.optimalPageWidth) * this.minimapBounds.width();
            float width = (float)this.getWidth() / this.toCurrentScale(this.optimalPageWidth) * this.minimapBounds.width();
            float y = -this.currentYOffset / this.toCurrentScale(this.optimalPageHeight) * this.minimapBounds.height();
            float height = (float)this.getHeight() / this.toCurrentScale(this.optimalPageHeight) * this.minimapBounds.height();
            this.minimapScreenBounds = new RectF(this.minimapBounds.left + x, this.minimapBounds.top + y, this.minimapBounds.left + x + width, this.minimapBounds.top + y + height);
            this.minimapScreenBounds.intersect(this.minimapBounds);
            this.miniMapRequired = true;
        }
    }

    private void calculateMasksBounds() {
        this.leftMask = new RectF(0.0f, 0.0f, (float)(this.getWidth() / 2) - this.toCurrentScale(this.optimalPageWidth) / 2.0f, (float)this.getHeight());
        this.rightMask = new RectF((float)(this.getWidth() / 2) + this.toCurrentScale(this.optimalPageWidth) / 2.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
    }

    public void moveTo(float offsetX, float offsetY) {
        if (this.swipeVertical) {
            if (this.toCurrentScale(this.optimalPageWidth) < (float)this.getWidth()) {
                offsetX = (float)(this.getWidth() / 2) - this.toCurrentScale(this.optimalPageWidth) / 2.0f;
            } else if (offsetX > 0.0f) {
                offsetX = 0.0f;
            } else if (offsetX + this.toCurrentScale(this.optimalPageWidth) < (float)this.getWidth()) {
                offsetX = (float)this.getWidth() - this.toCurrentScale(this.optimalPageWidth);
            }
            if (this.isZooming()) {
                if (this.toCurrentScale(this.optimalPageHeight) < (float)this.getHeight()) {
                    this.miniMapRequired = false;
                    offsetY = (float)(this.getHeight() / 2) - this.toCurrentScale(((float)this.currentFilteredPage + 0.5f) * this.optimalPageHeight);
                } else {
                    this.miniMapRequired = true;
                    if (offsetY + this.toCurrentScale((float)this.currentFilteredPage * this.optimalPageHeight) > 0.0f) {
                        offsetY = -this.toCurrentScale((float)this.currentFilteredPage * this.optimalPageHeight);
                    } else if (offsetY + this.toCurrentScale((float)(this.currentFilteredPage + 1) * this.optimalPageHeight) < (float)this.getHeight()) {
                        offsetY = (float)this.getHeight() - this.toCurrentScale((float)(this.currentFilteredPage + 1) * this.optimalPageHeight);
                    }
                }
            } else {
                float maxY = this.calculateCenterOffsetForPage(this.currentFilteredPage + 1);
                float minY = this.calculateCenterOffsetForPage(this.currentFilteredPage - 1);
                if (offsetY < maxY) {
                    offsetY = maxY;
                } else if (offsetY > minY) {
                    offsetY = minY;
                }
            }
        } else {
            if (this.toCurrentScale(this.optimalPageHeight) < (float)this.getHeight()) {
                offsetY = (float)(this.getHeight() / 2) - this.toCurrentScale(this.optimalPageHeight) / 2.0f;
            } else if (offsetY > 0.0f) {
                offsetY = 0.0f;
            } else if (offsetY + this.toCurrentScale(this.optimalPageHeight) < (float)this.getHeight()) {
                offsetY = (float)this.getHeight() - this.toCurrentScale(this.optimalPageHeight);
            }
            if (this.isZooming()) {
                if (this.toCurrentScale(this.optimalPageWidth) < (float)this.getWidth()) {
                    this.miniMapRequired = false;
                    offsetX = (float)(this.getWidth() / 2) - this.toCurrentScale(((float)this.currentFilteredPage + 0.5f) * this.optimalPageWidth);
                } else {
                    this.miniMapRequired = true;
                    if (offsetX + this.toCurrentScale((float)this.currentFilteredPage * this.optimalPageWidth) > 0.0f) {
                        offsetX = -this.toCurrentScale((float)this.currentFilteredPage * this.optimalPageWidth);
                    } else if (offsetX + this.toCurrentScale((float)(this.currentFilteredPage + 1) * this.optimalPageWidth) < (float)this.getWidth()) {
                        offsetX = (float)this.getWidth() - this.toCurrentScale((float)(this.currentFilteredPage + 1) * this.optimalPageWidth);
                    }
                }
            } else {
                float maxX = this.calculateCenterOffsetForPage(this.currentFilteredPage + 1);
                float minX = this.calculateCenterOffsetForPage(this.currentFilteredPage - 1);
                if (offsetX < maxX) {
                    offsetX = maxX;
                } else if (offsetX > minX) {
                    offsetX = minX;
                }
            }
        }
        this.currentXOffset = offsetX;
        this.currentYOffset = offsetY;
        this.calculateMinimapAreaBounds();
        this.invalidate();
    }

    public void moveRelativeTo(float dx, float dy) {
        this.moveTo(this.currentXOffset + dx, this.currentYOffset + dy);
    }

    public void zoomTo(float zoom) {
        this.zoom = zoom;
        this.calculateMasksBounds();
    }

    public void zoomCenteredTo(float zoom, PointF pivot) {
        float dzoom = zoom / this.zoom;
        this.zoomTo(zoom);
        float baseX = this.currentXOffset * dzoom;
        float baseY = this.currentYOffset * dzoom;
        this.moveTo(baseX += pivot.x - pivot.x * dzoom, baseY += pivot.y - pivot.y * dzoom);
    }

    public void zoomCenteredRelativeTo(float dzoom, PointF pivot) {
        this.zoomCenteredTo(this.zoom * dzoom, pivot);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public float getCurrentXOffset() {
        return this.currentXOffset;
    }

    public float getCurrentYOffset() {
        return this.currentYOffset;
    }

    public float toRealScale(float size) {
        return size / this.zoom;
    }

    public float toCurrentScale(float size) {
        return size * this.zoom;
    }

    public float getZoom() {
        return this.zoom;
    }

    public boolean isZooming() {
        return this.zoom != this.minZoom;
    }

    public float getOptimalPageWidth() {
        return this.optimalPageWidth;
    }

    public float getOptimalPageHeight() {
        return this.optimalPageHeight;
    }

    private void setUserWantsMinimap(boolean userWantsMinimap) {
        this.userWantsMinimap = userWantsMinimap;
    }

    private void setDefaultPage(int defaultPage) {
        this.defaultPage = defaultPage;
    }

    public void resetZoom() {
        this.zoomTo(this.minZoom);
    }

    public void resetZoomWithAnimation() {
        this.zoomWithAnimation(this.minZoom);
    }

    public void zoomWithAnimation(float centerX, float centerY, float scale) {
        this.animationManager.startZoomAnimation(centerX, centerY, this.zoom, scale);
    }

    public void zoomWithAnimation(float scale) {
        this.animationManager.startZoomAnimation(this.getWidth() / 2, this.getHeight() / 2, this.zoom, scale);
    }

    public void setScrollBar(ScrollBar scrollBar) {
        this.scrollBar = scrollBar;
        scrollBar.addToPDFView(this);
    }

    public float getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(float minZoom) {
        this.minZoom = minZoom;
    }

    public float getMidZoom() {
        return this.midZoom;
    }

    public void setMidZoom(float midZoom) {
        this.midZoom = midZoom;
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(float maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void useBestQuality(boolean bestQuality) {
        this.bestQuality = bestQuality;
    }

    public void enableAnnotationRendering(boolean annotationRendering) {
        this.annotationRendering = annotationRendering;
    }

    public PdfDocument.Meta getDocumentMeta() {
        if (this.pdfDocument == null) {
            return null;
        }
        return this.pdfiumCore.getDocumentMeta(this.pdfDocument);
    }

    public List<PdfDocument.Bookmark> getTableOfContents() {
        if (this.pdfDocument == null) {
            return new ArrayList<PdfDocument.Bookmark>();
        }
        return this.pdfiumCore.getTableOfContents(this.pdfDocument);
    }

    public Configurator fromAsset(String assetName) {
        return new Configurator(new AssetSource(assetName));
    }

    public Configurator fromFile(File file) {
        return new Configurator(new FileSource(file));
    }

    public Configurator fromUri(Uri uri) {
        return new Configurator(new UriSource(uri));
    }

    public Configurator fromBytes(byte[] bytes) {
        return new Configurator(new ByteArraySource(bytes));
    }

    public Configurator fromStream(InputStream stream) {
        return new Configurator(new InputStreamSource(stream));
    }

    public Configurator fromSource(DocumentSource docSource) {
        return new Configurator(docSource);
    }

    public boolean isSwipeVertical() {
        return this.swipeVertical;
    }

    public void setSwipeVertical(boolean swipeVertical) {
        this.swipeVertical = swipeVertical;
    }

    public void setShowPageWithAnimation(boolean showPageWithAnimation) {
        this.showPageWithAnimation = showPageWithAnimation;
    }

    public class Configurator {
        private final DocumentSource documentSource;
        private int[] pageNumbers = null;
        private boolean enableSwipe = true;
        private boolean enableDoubletap = true;
        private OnDrawListener onDrawListener;
        private OnLoadCompleteListener onLoadCompleteListener;
        private OnErrorListener onErrorListener;
        private OnPageChangeListener onPageChangeListener;
        private int defaultPage = 1;
        private boolean showMinimap = false;
        private boolean swipeVertical = false;
        private boolean showPageWithAnimation = true;
        private boolean annotationRendering = false;
        private int maskColor = -16777216;
        private int maskAlpha = 20;
        private String password = null;

        private Configurator(DocumentSource documentSource) {
            this.documentSource = documentSource;
        }

        public Configurator pages(int ... pageNumbers) {
            this.pageNumbers = pageNumbers;
            return this;
        }

        public Configurator enableSwipe(boolean enableSwipe) {
            this.enableSwipe = enableSwipe;
            return this;
        }

        public Configurator enableDoubletap(boolean enableDoubletap) {
            this.enableDoubletap = enableDoubletap;
            return this;
        }

        public Configurator enableAnnotationRendering(boolean annotationRendering) {
            this.annotationRendering = annotationRendering;
            return this;
        }

        public Configurator onDraw(OnDrawListener onDrawListener) {
            this.onDrawListener = onDrawListener;
            return this;
        }

        public Configurator onLoad(OnLoadCompleteListener onLoadCompleteListener) {
            this.onLoadCompleteListener = onLoadCompleteListener;
            return this;
        }

        public Configurator onError(OnErrorListener onErrorListener) {
            this.onErrorListener = onErrorListener;
            return this;
        }

        public Configurator onPageChange(OnPageChangeListener onPageChangeListener) {
            this.onPageChangeListener = onPageChangeListener;
            return this;
        }

        public Configurator defaultPage(int defaultPage) {
            this.defaultPage = defaultPage;
            return this;
        }

        public Configurator swipeVertical(boolean swipeVertical) {
            this.swipeVertical = swipeVertical;
            return this;
        }

        public Configurator showPageWithAnimation(boolean showPageWithAnimation) {
            this.showPageWithAnimation = showPageWithAnimation;
            return this;
        }

        public Configurator password(String password) {
            this.password = password;
            return this;
        }

        public Configurator mask(int maskColor, int maskAlpha) {
            this.maskColor = maskColor;
            this.maskAlpha = maskAlpha;
            return this;
        }

        public void load() {
            PDFView.this.recycle();
            PDFView.this.setOnDrawListener(this.onDrawListener);
            PDFView.this.setOnPageChangeListener(this.onPageChangeListener);
            PDFView.this.enableSwipe(this.enableSwipe);
            PDFView.this.enableDoubletap(this.enableDoubletap);
            PDFView.this.setDefaultPage(this.defaultPage);
            PDFView.this.setUserWantsMinimap(this.showMinimap);
            PDFView.this.setSwipeVertical(this.swipeVertical);
            PDFView.this.setShowPageWithAnimation(this.showPageWithAnimation);
            PDFView.this.enableAnnotationRendering(this.annotationRendering);
            PDFView.this.dragPinchManager.setSwipeVertical(this.swipeVertical);
            PDFView.this.maskPaint = new Paint();
            PDFView.this.maskPaint.setColor(this.maskColor);
            PDFView.this.maskPaint.setAlpha(this.maskAlpha);
            if (this.pageNumbers != null) {
                PDFView.this.load(this.documentSource, this.password, this.onLoadCompleteListener, this.onErrorListener, this.pageNumbers);
            } else {
                PDFView.this.load(this.documentSource, this.password, this.onLoadCompleteListener, this.onErrorListener);
            }
        }

        public Configurator showMinimap(boolean showMinimap) {
            this.showMinimap = showMinimap;
            return this;
        }
    }

    private static enum State {
        DEFAULT,
        LOADED,
        SHOWN;

    }
}

