/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.content.Context;
import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import com.github.barteksc.pdfviewer.AnimationManager;
import com.github.barteksc.pdfviewer.PDFView;

class DragPinchManager
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
ScaleGestureDetector.OnScaleGestureListener,
View.OnTouchListener {
    private PDFView pdfView;
    private AnimationManager animationManager;
    private GestureDetector gestureDetector;
    private ScaleGestureDetector scaleGestureDetector;
    private float startDragX;
    private float startDragY;
    private boolean isSwipeEnabled;
    private boolean swipeVertical;
    private boolean scrolling = false;
    private boolean scaling = false;
    private boolean flingPageChange = false;
    private float maxFlingVelocity = 0.0f;

    public DragPinchManager(PDFView pdfView, AnimationManager animationManager) {
        this.pdfView = pdfView;
        this.animationManager = animationManager;
        this.isSwipeEnabled = false;
        this.swipeVertical = pdfView.isSwipeVertical();
        this.gestureDetector = new GestureDetector(pdfView.getContext(), (GestureDetector.OnGestureListener)this);
        this.scaleGestureDetector = new ScaleGestureDetector(pdfView.getContext(), (ScaleGestureDetector.OnScaleGestureListener)this);
        this.maxFlingVelocity = ViewConfiguration.get((Context)pdfView.getContext()).getScaledMaximumFlingVelocity();
        pdfView.setOnTouchListener(this);
    }

    public void enableDoubletap(boolean enableDoubletap) {
        if (enableDoubletap) {
            this.gestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)this);
        } else {
            this.gestureDetector.setOnDoubleTapListener(null);
        }
    }

    public boolean isZooming() {
        return this.pdfView.isZooming();
    }

    private boolean isPageChange(float distance) {
        return Math.abs(distance) > Math.abs(this.pdfView.toCurrentScale(this.swipeVertical ? this.pdfView.getOptimalPageHeight() : this.pdfView.getOptimalPageWidth()) / 2.0f);
    }

    public void setSwipeEnabled(boolean isSwipeEnabled) {
        this.isSwipeEnabled = isSwipeEnabled;
    }

    public void setSwipeVertical(boolean swipeVertical) {
        this.swipeVertical = swipeVertical;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        this.pdfView.performClick();
        return true;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (this.pdfView.getZoom() < this.pdfView.getMidZoom()) {
            this.pdfView.zoomWithAnimation(e.getX(), e.getY(), this.pdfView.getMidZoom());
        } else if (this.pdfView.getZoom() < this.pdfView.getMaxZoom()) {
            this.pdfView.zoomWithAnimation(e.getX(), e.getY(), this.pdfView.getMaxZoom());
        } else {
            this.pdfView.resetZoomWithAnimation();
        }
        return true;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        return false;
    }

    public boolean onDown(MotionEvent e) {
        this.startDragX = e.getX();
        this.startDragY = e.getY();
        this.animationManager.stopFling();
        return true;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.scrolling = true;
        if (this.isZooming() || this.isSwipeEnabled) {
            this.pdfView.moveRelativeTo(-distanceX, -distanceY);
        }
        return true;
    }

    public void onScrollEnd(MotionEvent event) {
        if (!this.isZooming() && !this.flingPageChange) {
            if (this.scaling) {
                this.pdfView.showPage(this.pdfView.getCurrentPage());
                return;
            }
            if (this.isSwipeEnabled) {
                int diff;
                float distance = this.swipeVertical ? event.getY() - this.startDragY : event.getX() - this.startDragX;
                int n = diff = distance > 0.0f ? -1 : 1;
                if (this.isPageChange(distance)) {
                    this.pdfView.showPage(this.pdfView.getCurrentPage() + diff);
                } else {
                    this.pdfView.showPage(this.pdfView.getCurrentPage());
                }
            }
        } else {
            this.pdfView.loadPages();
        }
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.scaling) {
            return false;
        }
        if (!this.isZooming()) {
            int diff;
            if (this.swipeVertical) {
                float factor = velocityY / this.maxFlingVelocity;
                if ((double)Math.abs(factor) < 0.1) {
                    return false;
                }
                diff = velocityY > 0.0f ? -1 : 1;
            } else {
                float factor = velocityX / this.maxFlingVelocity;
                if ((double)Math.abs(factor) < 0.1) {
                    return false;
                }
                diff = velocityX > 0.0f ? -1 : 1;
            }
            this.flingPageChange = true;
            this.pdfView.showPage(this.pdfView.getCurrentPage() + diff);
        } else {
            int xOffset = (int)this.pdfView.getCurrentXOffset();
            int yOffset = (int)this.pdfView.getCurrentYOffset();
            this.animationManager.startFlingAnimation(xOffset, yOffset, (int)(velocityX / 2.0f), (int)(velocityY / 2.0f), xOffset * 2, (int)this.pdfView.toCurrentScale(this.pdfView.getOptimalPageWidth()), yOffset * 2, (int)this.pdfView.toCurrentScale(this.pdfView.getOptimalPageHeight()));
        }
        return true;
    }

    public boolean onScale(ScaleGestureDetector detector) {
        this.scaling = true;
        float dr = detector.getScaleFactor();
        float wantedZoom = this.pdfView.getZoom() * dr;
        if (wantedZoom < 1.0f) {
            dr = 1.0f / this.pdfView.getZoom();
        } else if (wantedZoom > 10.0f) {
            dr = 10.0f / this.pdfView.getZoom();
        }
        this.pdfView.zoomCenteredRelativeTo(dr, new PointF(detector.getFocusX(), detector.getFocusY()));
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        this.pdfView.loadPages();
    }

    public boolean onTouch(View v, MotionEvent event) {
        boolean retVal = this.scaleGestureDetector.onTouchEvent(event);
        boolean bl = retVal = this.gestureDetector.onTouchEvent(event) || retVal;
        if (event.getAction() == 1) {
            if (this.scrolling) {
                this.onScrollEnd(event);
            }
            this.scrolling = false;
            this.scaling = false;
            this.flingPageChange = false;
        }
        return retVal;
    }
}

