/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.AsyncTask;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.model.PagePart;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import java.util.ArrayList;
import java.util.List;

class RenderingAsyncTask
extends AsyncTask<Void, PagePart, Void> {
    private PdfiumCore pdfiumCore;
    private PdfDocument pdfDocument;
    private final List<RenderingTask> renderingTasks = new ArrayList<RenderingTask>();
    private PDFView pdfView;
    private RectF renderBounds = new RectF();
    private Rect roundedRenderBounds = new Rect();
    private Matrix renderMatrix = new Matrix();

    public RenderingAsyncTask(PDFView pdfView, PdfiumCore pdfiumCore, PdfDocument pdfDocument) {
        this.pdfView = pdfView;
        this.pdfiumCore = pdfiumCore;
        this.pdfDocument = pdfDocument;
    }

    public void addRenderingTask(int userPage, int page, float width, float height, RectF bounds, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering) {
        RenderingTask task = new RenderingTask(width, height, bounds, userPage, page, thumbnail, cacheOrder, bestQuality, annotationRendering);
        this.renderingTasks.add(task);
        this.wakeUp();
    }

    protected void onPreExecute() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground(Void ... params) {
        while (!this.isCancelled()) {
            while (true) {
                RenderingTask task;
                List<RenderingTask> list = this.renderingTasks;
                synchronized (list) {
                    if (this.renderingTasks.isEmpty()) {
                        break;
                    }
                    task = this.renderingTasks.get(0);
                }
                if (task == null) continue;
                PagePart part = this.proceed(task);
                if (this.renderingTasks.remove(task)) {
                    this.publishProgress(new PagePart[]{part});
                    continue;
                }
                part.getRenderedBitmap().recycle();
            }
            if (this.waitForRenderingTasks() && !this.isCancelled()) continue;
            return null;
        }
        return null;
    }

    protected void onProgressUpdate(PagePart ... part) {
        this.pdfView.onBitmapRendered(part[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForRenderingTasks() {
        try {
            List<RenderingTask> list = this.renderingTasks;
            synchronized (list) {
                this.renderingTasks.wait();
            }
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private PagePart proceed(RenderingTask renderingTask) {
        int w = Math.round(renderingTask.width);
        int h = Math.round(renderingTask.height);
        Bitmap render = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.calculateBounds(w, h, renderingTask.bounds);
        this.pdfiumCore.renderPageBitmap(this.pdfDocument, render, renderingTask.page, this.roundedRenderBounds.left, this.roundedRenderBounds.top, this.roundedRenderBounds.width(), this.roundedRenderBounds.height(), renderingTask.annotationRendering);
        if (!renderingTask.bestQuality) {
            Bitmap cpy = render.copy(Bitmap.Config.RGB_565, false);
            render.recycle();
            render = cpy;
        }
        return new PagePart(renderingTask.userPage, renderingTask.page, render, renderingTask.width, renderingTask.height, renderingTask.bounds, renderingTask.thumbnail, renderingTask.cacheOrder);
    }

    private void calculateBounds(int width, int height, RectF pageSliceBounds) {
        this.renderMatrix.reset();
        this.renderMatrix.postTranslate(-pageSliceBounds.left * (float)width, -pageSliceBounds.top * (float)height);
        this.renderMatrix.postScale(1.0f / pageSliceBounds.width(), 1.0f / pageSliceBounds.height());
        this.renderBounds.set(0.0f, 0.0f, (float)width, (float)height);
        this.renderMatrix.mapRect(this.renderBounds);
        this.renderBounds.round(this.roundedRenderBounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTasks() {
        List<RenderingTask> list = this.renderingTasks;
        synchronized (list) {
            this.renderingTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        List<RenderingTask> list = this.renderingTasks;
        synchronized (list) {
            this.renderingTasks.notify();
        }
    }

    private class RenderingTask {
        float width;
        float height;
        RectF bounds;
        int page;
        int userPage;
        boolean thumbnail;
        int cacheOrder;
        boolean bestQuality;
        boolean annotationRendering;

        public RenderingTask(float width, float height, RectF bounds, int userPage, int page, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering) {
            this.page = page;
            this.width = width;
            this.height = height;
            this.bounds = bounds;
            this.userPage = userPage;
            this.thumbnail = thumbnail;
            this.cacheOrder = cacheOrder;
            this.bestQuality = bestQuality;
            this.annotationRendering = annotationRendering;
        }
    }
}

