/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.github.barteksc.pdfviewer.ScrollBar;
import com.github.barteksc.pdfviewer.util.Util;

public class ScrollBarPageIndicator
extends RelativeLayout {
    private static final int INDICATOR_WIDTH = 75;
    private static final int INDICATOR_HEIGHT = 75;
    private static final int INDICATOR_TEXT_SIZE = 40;
    protected TextView textView;
    protected Context context;
    private ScrollBar scrollBar;

    public ScrollBarPageIndicator(Context context) {
        super(context);
        this.context = context;
        this.textView = new TextView(context);
        this.setVisibility(4);
    }

    public void setSize(int size) {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.getLayoutParams();
        lp.setMargins(0, 0, size + Util.getDP(this.getContext(), 10), 0);
        this.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    void addToScrollBar(ScrollBar scrollBar) {
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Util.getDP(this.getContext(), 75), Util.getDP(this.getContext(), 75));
        lp.setMargins(0, 0, Util.getDP(this.getContext(), 15) + scrollBar.getWidth(), 0);
        this.textView.setTextSize(1, 40.0f);
        RelativeLayout.LayoutParams tvlp = new RelativeLayout.LayoutParams(-2, -2);
        tvlp.addRule(13, -1);
        this.addView((View)this.textView, (ViewGroup.LayoutParams)tvlp);
        lp.addRule(7, scrollBar.getId());
        ((ViewGroup)scrollBar.getParent()).addView((View)this, (ViewGroup.LayoutParams)lp);
        this.scrollBar = scrollBar;
    }

    void setScroll(float y) {
        if (this.getVisibility() == 0) {
            if ((y -= (float)Util.getDP(this.getContext(), 37) - this.scrollBar.getHandlerHeight() / 2.0f) < 5.0f) {
                y = 5.0f;
            } else if (y > (float)(this.scrollBar.getHeight() - Util.getDP(this.getContext(), 75))) {
                y = this.scrollBar.getHeight() - Util.getDP(this.getContext(), 75);
            }
            this.setY(y);
        }
    }

    void setPageNum(int page) {
        String text = String.valueOf(page);
        if (!this.textView.getText().equals(text)) {
            this.textView.setText((CharSequence)text);
        }
    }

    void setTextColor(int color) {
        this.textView.setTextColor(color);
    }
}

