/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.R;
import com.github.barteksc.pdfviewer.ScrollBarPageIndicator;
import com.github.barteksc.pdfviewer.util.Util;

public class ScrollBar
extends View {
    private static final String TAG = ScrollBar.class.getSimpleName();
    private int handlerColor = 0;
    private int indicatorColor = 0;
    private int indicatorTextColor = 0;
    private Paint handlerPaint;
    private float handlerHeight = 0.0f;
    private int viewWidth;
    private PDFView pdfView;
    private PointF handlerPos;
    private int currentPage = 0;
    private ScrollBarPageIndicator indicator;

    public ScrollBar(Context context) {
        super(context);
        this.init();
    }

    public ScrollBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs, 0);
        this.init();
    }

    public ScrollBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.indicator = new ScrollBarPageIndicator(this.getContext());
        this.setIndicatorPage(this.currentPage);
        this.indicator.setBackgroundColor(this.indicatorColor);
        this.indicator.setTextColor(this.indicatorTextColor);
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                ScrollBar.this.indicator.addToScrollBar(ScrollBar.this);
                ScrollBar.this.removeOnLayoutChangeListener(this);
            }
        });
        this.handlerPaint = new Paint(1);
        this.handlerPaint.setStyle(Paint.Style.FILL);
        this.handlerPaint.setColor(this.handlerColor);
        if (this.getBackground() == null) {
            this.setBackgroundColor(-3355444);
        }
        this.handlerPos = new PointF(0.0f, 0.0f);
        this.viewWidth = Util.getDP(this.getContext(), 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.ScrollBar, defStyleAttr, 0);
        try {
            this.handlerColor = a.getColor(R.styleable.ScrollBar_sb_handlerColor, Color.parseColor((String)"#FF4081"));
            this.indicatorColor = a.getColor(R.styleable.ScrollBar_sb_indicatorColor, Color.parseColor((String)"#FF4081"));
            this.indicatorTextColor = a.getColor(R.styleable.ScrollBar_sb_indicatorTextColor, -1);
        }
        finally {
            a.recycle();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.isPDFViewReady()) {
            this.calculateHandlerHeight();
            this.calculateHandlerPosByPage(this.currentPage);
        }
    }

    float getHandlerHeight() {
        return this.handlerHeight;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minw = this.getPaddingLeft() + this.getPaddingRight() + this.viewWidth;
        int w = ScrollBar.resolveSizeAndState((int)minw, (int)widthMeasureSpec, (int)1);
        int minh = View.MeasureSpec.getSize((int)heightMeasureSpec) + this.getPaddingBottom() + this.getPaddingTop();
        int h = ScrollBar.resolveSizeAndState((int)minh, (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(w, h);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)Util.getDP(this.getContext(), 40), this.handlerPaint);
            return;
        }
        if (!this.isPDFViewReady()) {
            return;
        }
        if (Float.isNaN(this.handlerPos.y) || Float.isInfinite(this.handlerPos.y)) {
            this.calculateHandlerPosByPage(this.currentPage);
        }
        canvas.drawRect(this.handlerPos.x, this.handlerPos.y, (float)this.getWidth(), this.handlerPos.y + this.handlerHeight, this.handlerPaint);
    }

    private void calculateHandlerPosByPage(int position) {
        this.handlerPos.y = (float)position * this.handlerHeight;
    }

    private void calculateHandlerHeight() {
        this.handlerHeight = (float)this.getHeight() / (float)this.getPagesCount();
    }

    private boolean isPDFViewReady() {
        return this.pdfView != null && this.pdfView.getPageCount() > 0;
    }

    private int getPagesCount() {
        return this.isPDFViewReady() ? this.pdfView.getPageCount() : 0;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isPDFViewReady()) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: 
            case 2: 
            case 5: {
                float y = event.getY();
                if (y < 0.0f || y > (float)this.getHeight()) {
                    return true;
                }
                int pageNum = (int)Math.floor(y / this.handlerHeight);
                float handleY = (float)pageNum * this.handlerHeight;
                if (handleY < 0.0f) {
                    handleY = 0.0f;
                } else if (y + this.handlerHeight / 2.0f > (float)this.getHeight()) {
                    handleY = (float)this.getHeight() - this.handlerHeight;
                }
                this.handlerPos.y = handleY;
                if (pageNum != this.currentPage) {
                    this.indicator.setPageNum(pageNum + 1);
                }
                this.currentPage = pageNum;
                this.indicator.setVisibility(0);
                this.indicator.setScroll(handleY);
                this.invalidate();
                return true;
            }
            case 1: 
            case 3: 
            case 6: {
                int pgNum = (int)Math.floor(event.getY() / this.handlerHeight);
                this.pdfView.jumpTo(pgNum + 1);
                this.currentPage = pgNum;
                this.indicator.setVisibility(4);
                this.invalidate();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    public void setCurrentPage(int page) {
        if (!this.isPDFViewReady()) {
            throw new IllegalStateException("PDFView not set");
        }
        this.currentPage = page;
        this.pdfView.jumpTo(page);
        this.invalidate();
    }

    private void setIndicatorPage(int position) {
        this.indicator.setPageNum(position + 1);
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.currentPage = savedState.currentPage;
        this.setIndicatorPage(this.currentPage);
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPage = this.currentPage;
        return savedState;
    }

    void addToPDFView(PDFView pdfView) {
        this.pdfView = pdfView;
        this.calculateHandlerHeight();
        this.pageChanged(pdfView.getCurrentPage());
    }

    void pdfLoaded() {
        this.calculateHandlerHeight();
    }

    void pageChanged(int page) {
        this.currentPage = page;
        this.calculateHandlerPosByPage(this.currentPage);
        this.invalidate();
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPage;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPage = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPage);
        }
    }
}

