/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.URLInfo;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectSingle
extends Direct {
    public DirectSingle(DownloadInfo info, File target) {
        super(info, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadPart(RetryWrap.Wrap w, DownloadInfo info, AtomicBoolean stop, Runnable notify) throws IOException {
        RandomAccessFile fos = null;
        try {
            HttpURLConnection conn = info.openConnection();
            File f = this.target;
            info.setCount(0L);
            f.createNewFile();
            fos = new RandomAccessFile(f, "rw");
            byte[] bytes = new byte[BUF_SIZE];
            int read = 0;
            RetryWrap.check(conn);
            BufferedInputStream binaryreader = new BufferedInputStream(conn.getInputStream());
            while ((read = binaryreader.read(bytes)) > 0) {
                w.resume();
                fos.write(bytes, 0, read);
                info.setCount(info.getCount() + (long)read);
                notify.run();
                if (stop.get()) {
                    throw new DownloadInterruptedError("stop");
                }
                if (!Thread.interrupted()) continue;
                throw new DownloadInterruptedError("interrupted");
            }
            binaryreader.close();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    @Override
    public void download(final AtomicBoolean stop, final Runnable notify) {
        this.info.setState(URLInfo.States.DOWNLOADING);
        notify.run();
        try {
            RetryWrap.wrap(stop, new RetryWrap.Wrap(){

                @Override
                public void proxy() {
                    DirectSingle.this.info.getProxy().set();
                }

                @Override
                public void resume() {
                    DirectSingle.this.info.setRetry(0);
                }

                @Override
                public void error(Throwable e) {
                    DirectSingle.this.info.setRetry(DirectSingle.this.info.getRetry() + 1);
                }

                @Override
                public void download() throws IOException {
                    DirectSingle.this.info.setState(URLInfo.States.DOWNLOADING);
                    notify.run();
                    DirectSingle.this.downloadPart(this, DirectSingle.this.info, stop, notify);
                }

                @Override
                public boolean retry(int delay, Throwable e) {
                    DirectSingle.this.info.setDelay(delay, e);
                    notify.run();
                    return RetryWrap.retry(DirectSingle.this.info.getRetry());
                }

                @Override
                public void moved(URL url) {
                    DirectSingle.this.info.setState(URLInfo.States.RETRYING);
                    notify.run();
                }
            });
            this.info.setState(URLInfo.States.DONE);
            notify.run();
        }
        catch (DownloadInterruptedError e) {
            this.info.setState(URLInfo.States.STOP);
            notify.run();
            throw e;
        }
        catch (RuntimeException e) {
            this.info.setState(URLInfo.States.ERROR);
            notify.run();
            throw e;
        }
    }

    public static boolean canResume(DownloadInfo info, File targetFile) {
        if (info.getCount() != 0L) {
            return false;
        }
        return !targetFile.exists() || targetFile.length() == 0L;
    }
}

