/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.widget.aspect;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.View;
import com.artemkopan.widget.R;

final class AspectViewHelper {
    private int aspectWidth = 1;
    private int aspectHeight = 1;
    private boolean aspectByHeight = false;

    AspectViewHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.getResources().obtainAttributes(attrs, R.styleable.AspectHelper);
        try {
            this.aspectWidth = a.getInteger(R.styleable.AspectHelper_aspect_width, 1);
            this.aspectHeight = a.getInteger(R.styleable.AspectHelper_aspect_height, 1);
            this.aspectByHeight = a.getBoolean(R.styleable.AspectHelper_aspect_by_height, false);
        }
        finally {
            a.recycle();
        }
    }

    Point calculateNewMeasure(View view) {
        int newSpecWidth;
        int newSpecHeight;
        if (this.aspectByHeight) {
            newSpecHeight = View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredHeight(), (int)0x40000000);
            int newW = Math.round((float)view.getMeasuredHeight() * (float)this.aspectWidth / (float)this.aspectHeight);
            newSpecWidth = View.MeasureSpec.makeMeasureSpec((int)newW, (int)0x40000000);
        } else {
            newSpecWidth = View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredWidth(), (int)0x40000000);
            int newH = Math.round((float)view.getMeasuredWidth() * (float)this.aspectHeight / (float)this.aspectWidth);
            newSpecHeight = View.MeasureSpec.makeMeasureSpec((int)newH, (int)0x40000000);
        }
        return new Point(newSpecWidth, newSpecHeight);
    }
}

