/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v7.widget.RecyclerView;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.artemkopan.recycler.R;
import com.artemkopan.recycler.listeners.OnRecyclerPaginationListener;
import com.artemkopan.widget.drawable.CircularProgressDrawable;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;

public class ExRecyclerView
extends RecyclerView {
    private static final int NO_VALUE = -1;
    private static final int BACKGROUND_DURATION = 2000;
    private static final String TAG = "ExRecyclerView";
    private StaticLayout textLayout;
    private TextPaint textPaint;
    private CircularProgressDrawable progressDrawable;
    private Drawable backgroundDrawable;
    private OnRecyclerPaginationListener paginationListener;
    private Disposable errorTimer;
    private CharSequence textCurrent;
    private int progressSize = -1;
    private int textGravity = 17;
    private Rect textMargin = new Rect();
    private int backgroundDuration = 2000;
    private boolean drawText;
    private boolean drawProgress;

    public ExRecyclerView(Context context) {
        this(context, null, 0);
    }

    public ExRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int borderWidth = -1;
        int progressColor = -1;
        int textSize = -1;
        int textColor = -16777216;
        if (attrs != null) {
            TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ExRecyclerView);
            try {
                this.progressSize = array.getDimensionPixelSize(R.styleable.ExRecyclerView_erv_progressSize, context.getResources().getDimensionPixelSize(R.dimen.base_progress_size));
                borderWidth = array.getDimensionPixelSize(R.styleable.ExRecyclerView_erv_progressBorderWidth, context.getResources().getDimensionPixelSize(R.dimen.base_progress_border_width));
                progressColor = array.getColor(R.styleable.ExRecyclerView_erv_progressColor, -1);
                textSize = array.getDimensionPixelSize(R.styleable.ExRecyclerView_erv_textSize, textSize);
                textColor = array.getColor(R.styleable.ExRecyclerView_erv_textColor, textColor);
                this.textGravity = array.getInteger(R.styleable.ExRecyclerView_erv_textGravity, this.textGravity);
                int textMarginLeft = array.getDimensionPixelOffset(R.styleable.ExRecyclerView_erv_textMarginLeft, 0);
                int textMarginTop = array.getDimensionPixelOffset(R.styleable.ExRecyclerView_erv_textMarginTop, 0);
                int textMarginRight = array.getDimensionPixelOffset(R.styleable.ExRecyclerView_erv_textMarginRight, 0);
                int textMarginBottom = array.getDimensionPixelOffset(R.styleable.ExRecyclerView_erv_textMarginBottom, 0);
                this.setTextMargin(textMarginLeft, textMarginTop, textMarginRight, textMarginBottom);
                this.backgroundDrawable = array.getDrawable(R.styleable.ExRecyclerView_erv_backgroundDrawable);
                this.backgroundDuration = array.getInt(R.styleable.ExRecyclerView_erv_background_duration, 2000);
            }
            finally {
                array.recycle();
            }
        } else {
            this.progressSize = context.getResources().getDimensionPixelSize(R.dimen.base_progress_size);
            borderWidth = context.getResources().getDimensionPixelSize(R.dimen.base_progress_border_width);
        }
        if (progressColor == -1) {
            progressColor = this.getColorPrimary();
        }
        if (textSize == -1) {
            textSize = this.getContext().getResources().getDimensionPixelSize(R.dimen.base_recycler_text_size);
        }
        if (this.backgroundDrawable == null) {
            this.backgroundDrawable = new ColorDrawable(this.getThemeBackgroundColor());
        }
        this.textPaint = new TextPaint(1);
        this.textPaint.setColor(textColor);
        this.textPaint.setTextSize((float)textSize);
        this.progressDrawable = new CircularProgressDrawable(progressColor, (float)borderWidth);
        this.progressDrawable.setCallback((Drawable.Callback)this);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed) {
            int w = this.getWidth();
            int h = this.getHeight();
            this.backgroundDrawable.setBounds(0, 0, w, h);
            this.progressDrawable.setBounds(w / 2 - this.progressSize / 2, h / 2 - this.progressSize / 2, w / 2 + this.progressSize / 2, h / 2 + this.progressSize / 2);
        }
    }

    public OnRecyclerPaginationListener createPaginationListener(OnRecyclerPaginationListener.OnRecyclerPaginationResult listener) {
        this.setPaginationListener(new OnRecyclerPaginationListener(this.getLayoutManager(), 0, listener));
        return this.paginationListener;
    }

    public void setPaginationListener(OnRecyclerPaginationListener scrollListener) {
        if (this.paginationListener != null) {
            this.removeOnScrollListener(this.paginationListener);
        }
        this.paginationListener = scrollListener;
        this.addOnScrollListener(scrollListener);
    }

    public void setPaginationState(boolean isEnable) {
        if (isEnable) {
            this.enablePagination();
        } else {
            this.disablePagination();
        }
    }

    public void enablePagination() {
        if (this.paginationListener != null) {
            this.paginationListener.enablePagination();
        }
    }

    public void disablePagination() {
        if (this.paginationListener != null) {
            this.paginationListener.disablePagination();
        }
    }

    public void setProgressColor(@ColorInt int color) {
        this.progressDrawable.setColor(color);
    }

    public void setTextMargin(int left, int top, int right, int bottom) {
        this.textMargin.set(left, top, right, bottom);
        this.textLayout = null;
        this.invalidate();
    }

    public void setTextSize(float textSize) {
        this.textPaint.setTextSize(textSize);
        this.invalidate();
    }

    public void setTextGravity(int textGravity) {
        this.textGravity = textGravity;
        this.invalidate();
    }

    public void setTextTypeface(Typeface textTypeface) {
        this.textPaint.setTypeface(textTypeface);
    }

    public void showText(@StringRes int textRes, Object ... arguments) {
        this.showText(this.getContext().getString(textRes, arguments));
    }

    public void showText(@StringRes int textRes) {
        this.showText(this.getContext().getString(textRes));
    }

    public void showText(CharSequence text) {
        this.drawText = true;
        this.drawProgress = false;
        this.textCurrent = text;
        this.textLayout = null;
        this.postInvalidate();
        if (this.getAdapter() != null && this.getAdapter().getItemCount() != 0) {
            if (this.errorTimer != null) {
                this.errorTimer.dispose();
            }
            this.errorTimer = Observable.timer((long)this.backgroundDuration, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    ExRecyclerView.this.hideText();
                }
            });
        }
    }

    public void hideText() {
        this.drawText = false;
        this.postInvalidate();
    }

    public void showProgress() {
        this.drawProgress = true;
        this.drawText = false;
        this.progressDrawable.start();
        this.postInvalidate();
    }

    public void hideProgress() {
        this.drawProgress = false;
        this.progressDrawable.stop();
        this.postInvalidate();
    }

    public void hideAll() {
        this.drawProgress = false;
        this.drawText = false;
        this.postInvalidate();
    }

    public void draw(Canvas c) {
        super.draw(c);
        this.drawBackground(c);
        this.drawProgress(c);
        this.drawText(c);
    }

    private void drawBackground(Canvas c) {
        if ((this.drawProgress || this.drawText) && this.getAdapter() != null && this.getAdapter().getItemCount() > 0) {
            int restore = c.save();
            this.backgroundDrawable.draw(c);
            c.restoreToCount(restore);
        }
    }

    private void drawProgress(Canvas c) {
        if (this.drawProgress) {
            this.progressDrawable.draw(c);
        }
    }

    private void drawText(Canvas c) {
        if (this.drawText) {
            if (this.textLayout == null) {
                this.createTextLayout();
            }
            int restore = c.save();
            int xHalf = c.getWidth() / 2;
            int yHalf = c.getHeight() / 2;
            int xStart = xHalf - this.textLayout.getWidth() / 2;
            switch (this.textGravity) {
                case 48: {
                    c.translate((float)xStart, (float)this.textMargin.top);
                    break;
                }
                case 80: {
                    c.translate((float)xStart, (float)(c.getHeight() - this.textLayout.getHeight() - this.textMargin.bottom));
                    break;
                }
                default: {
                    c.translate((float)xStart, (float)(yHalf - this.textLayout.getHeight() / 2 + this.textMargin.top));
                }
            }
            this.textLayout.draw(c);
            c.restoreToCount(restore);
        }
    }

    private void createTextLayout() {
        this.textLayout = new StaticLayout(this.textCurrent, this.textPaint, this.getWidth() - (this.textMargin.left + this.textMargin.right), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, true);
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return who == this.progressDrawable || super.verifyDrawable(who);
    }

    public boolean canScrollVertically(int direction) {
        if (direction < 1) {
            boolean original = super.canScrollVertically(direction);
            return !original && this.getChildAt(0) != null && this.getChildAt(0).getTop() < 0 || original;
        }
        return super.canScrollVertically(direction);
    }

    private int getThemeBackgroundColor() {
        TypedValue a = new TypedValue();
        this.getContext().getTheme().resolveAttribute(16842836, a, true);
        if (a.type >= 28 && a.type <= 31) {
            return a.data;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getColorPrimary() {
        int progressColor;
        TypedValue typedValue = new TypedValue();
        TypedArray a = this.getContext().obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorPrimary});
        try {
            progressColor = a.getColor(0, -16777216);
        }
        finally {
            a.recycle();
        }
        return progressColor;
    }
}

