/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.listeners;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class OnRecyclerPaginationListener
extends RecyclerView.OnScrollListener {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    protected RecyclerView.LayoutManager layoutManager;
    protected OnRecyclerPaginationResult onRecyclerPaginationResult;
    protected boolean loading = true;
    protected int type = 0;
    private int offset;

    public OnRecyclerPaginationListener(RecyclerView.LayoutManager layoutManager, int type, OnRecyclerPaginationResult onRecyclerPaginationResult) {
        this.layoutManager = layoutManager;
        this.type = type;
        this.onRecyclerPaginationResult = onRecyclerPaginationResult;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        int value;
        super.onScrolled(recyclerView, dx, dy);
        int n = value = this.type == 0 ? dy : dx;
        if (value != 0 && this.loading) {
            int pastVisibleItems;
            int visibleItemCount = this.layoutManager.getChildCount();
            int totalItemCount = this.layoutManager.getItemCount();
            if (this.layoutManager instanceof LinearLayoutManager) {
                pastVisibleItems = ((LinearLayoutManager)this.layoutManager).findFirstVisibleItemPosition();
            } else if (this.layoutManager instanceof GridLayoutManager) {
                pastVisibleItems = ((GridLayoutManager)this.layoutManager).findFirstVisibleItemPosition();
            } else {
                throw new UnsupportedOperationException("StaggerGridLayoutManager not support");
            }
            if (visibleItemCount + pastVisibleItems >= totalItemCount) {
                this.loading = false;
                this.onRecyclerPaginationResult.onRecyclePaginationNextPage();
            }
        }
    }

    public void enablePagination() {
        this.loading = true;
    }

    public void disablePagination() {
        this.loading = false;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void incOffset(int value, boolean enablePagination) {
        this.incOffset(value);
        this.loading = enablePagination;
    }

    public void incOffset(int value) {
        this.offset += value;
    }

    public RecyclerView.LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TypePagination {
    }

    public static interface OnRecyclerPaginationResult {
        public void onRecyclePaginationNextPage();
    }
}

