/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.recycler.decoration;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import java.util.ArrayList;
import java.util.List;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int LAST_POS = -1;
    private static final int[] ATTRS = new int[]{16843284};
    private final Rect bounds = new Rect();
    private List<Integer> excludePos = new ArrayList<Integer>();
    private Drawable divider;
    private int orientation;

    public DividerItemDecoration(Context context, int orientation) {
        TypedArray a = context.obtainStyledAttributes(ATTRS);
        this.divider = a.getDrawable(0);
        a.recycle();
        this.setOrientation(orientation);
    }

    public DividerItemDecoration(Context context, @DrawableRes int drawableRes, int orientation) {
        this(ContextCompat.getDrawable((Context)context, (int)drawableRes), orientation);
    }

    public DividerItemDecoration(Drawable divider, int orientation) {
        this.divider = divider;
        this.orientation = orientation;
    }

    public void addExcludePos(int pos) {
        this.excludePos.add(pos);
    }

    public void removeExcludePos(int pos) {
        this.excludePos.remove(pos);
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Invalid orientation. It should be either HORIZONTAL or VERTICAL");
        }
        this.orientation = orientation;
    }

    public void setDrawable(@NonNull Drawable drawable) {
        if (drawable == null) {
            throw new IllegalArgumentException("Drawable cannot be null.");
        }
        this.divider = drawable;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (parent.getLayoutManager() == null) {
            return;
        }
        if (this.orientation == 1) {
            this.drawVertical(c, parent);
        } else {
            this.drawHorizontal(c, parent);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void drawVertical(Canvas canvas, RecyclerView parent) {
        int right;
        int left;
        canvas.save();
        if (parent.getClipToPadding()) {
            left = parent.getPaddingLeft();
            right = parent.getWidth() - parent.getPaddingRight();
            canvas.clipRect(left, parent.getPaddingTop(), right, parent.getHeight() - parent.getPaddingBottom());
        } else {
            left = 0;
            right = parent.getWidth();
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (this.excludePos.contains(i) || this.excludePos.contains(-1) && i == childCount - 1) continue;
            View child = parent.getChildAt(i);
            parent.getDecoratedBoundsWithMargins(child, this.bounds);
            int bottom = this.bounds.bottom + Math.round(ViewCompat.getTranslationY((View)child));
            int top = bottom - this.divider.getIntrinsicHeight();
            this.divider.setBounds(left, top, right, bottom);
            this.divider.draw(canvas);
        }
        canvas.restore();
    }

    @SuppressLint(value={"NewApi"})
    private void drawHorizontal(Canvas canvas, RecyclerView parent) {
        int bottom;
        int top;
        canvas.save();
        if (parent.getClipToPadding()) {
            top = parent.getPaddingTop();
            bottom = parent.getHeight() - parent.getPaddingBottom();
            canvas.clipRect(parent.getPaddingLeft(), top, parent.getWidth() - parent.getPaddingRight(), bottom);
        } else {
            top = 0;
            bottom = parent.getHeight();
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (this.excludePos.contains(i) || this.excludePos.contains(-1) && i == childCount - 1) continue;
            View child = parent.getChildAt(i);
            parent.getLayoutManager().getDecoratedBoundsWithMargins(child, this.bounds);
            int right = this.bounds.right + Math.round(ViewCompat.getTranslationX((View)child));
            int left = right - this.divider.getIntrinsicWidth();
            this.divider.setBounds(left, top, right, bottom);
            this.divider.draw(canvas);
        }
        canvas.restore();
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (this.orientation == 1) {
            outRect.set(0, 0, 0, this.divider.getIntrinsicHeight());
        } else {
            outRect.set(0, 0, this.divider.getIntrinsicWidth(), 0);
        }
    }
}

