/*
 * Decompiled with CFR 0.152.
 */
package com.luseen.screenshotobserver;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Message;
import android.os.SystemClock;
import android.provider.MediaStore;
import com.luseen.screenshotobserver.ScreenShotContentObserver;

public abstract class ScreenshotObserverService
extends Service {
    private ScreenShotContentObserver screenShotContentObserver;

    public IBinder onBind(Intent intent) {
        return new Binder();
    }

    public void onCreate() {
        super.onCreate();
        this.registerScreenShotObserver();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        this.unRegisterScreenShotObserver();
    }

    public void onTaskRemoved(Intent rootIntent) {
        Intent restartServiceTask = new Intent(this.getApplicationContext(), ((Object)((Object)this)).getClass());
        restartServiceTask.setPackage(this.getPackageName());
        PendingIntent restartPendingIntent = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)restartServiceTask, (int)0x40000000);
        AlarmManager myAlarmService = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        myAlarmService.set(3, SystemClock.elapsedRealtime() + 1000L, restartPendingIntent);
        super.onTaskRemoved(rootIntent);
    }

    private void registerScreenShotObserver() {
        HandlerThread handlerThread = new HandlerThread("content_observer");
        handlerThread.start();
        Handler handler = new Handler(handlerThread.getLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
            }
        };
        this.screenShotContentObserver = new ScreenShotContentObserver(handler, (Context)this){

            @Override
            protected void onScreenShot(String path, String fileName) {
                super.onScreenShot(path, fileName);
                ScreenshotObserverService.this.onScreenShotTaken(path, fileName);
            }
        };
        this.getContentResolver().registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, true, (ContentObserver)this.screenShotContentObserver);
    }

    private void unRegisterScreenShotObserver() {
        this.getContentResolver().unregisterContentObserver((ContentObserver)this.screenShotContentObserver);
    }

    protected abstract void onScreenShotTaken(String var1, String var2);
}

