/*
 * Decompiled with CFR 0.152.
 */
package com.aita.aitawidgetlibrary.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.aita.aitawidgetlibrary.analytics.WidgetTracker;
import com.aita.aitawidgetlibrary.model.WidgetFlight;
import com.aita.aitawidgetlibrary.other.WidgetViewManager;

public abstract class WidgetView
extends RelativeLayout {
    private WidgetTracker mTracker;
    private WidgetViewManager mViewManager;

    public WidgetView(Context context) {
        super(context);
        WidgetView.inflate((Context)context, (int)this.getWidgetViewId(), (ViewGroup)this);
    }

    public WidgetView(Context context, AttributeSet attrs) {
        super(context, attrs);
        WidgetView.inflate((Context)context, (int)this.getWidgetViewId(), (ViewGroup)this);
    }

    public WidgetView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        WidgetView.inflate((Context)context, (int)this.getWidgetViewId(), (ViewGroup)this);
    }

    public abstract void init(WidgetFlight var1);

    public abstract void update(WidgetFlight var1);

    public final void setTracker(WidgetTracker tracker) {
        this.mTracker = tracker;
    }

    public final void setViewManager(WidgetViewManager viewManager) {
        this.mViewManager = viewManager;
    }

    protected final void sendEvent(String action) {
        this.sendEvent(action, null);
    }

    protected final void sendEvent(String action, String label) {
        if (this.mTracker != null) {
            this.mTracker.sendEvent(action, label);
        }
    }

    protected final void hideWidget() {
        this.mViewManager.setWidgetViewVisible(false);
    }

    protected final void showWidget() {
        this.mViewManager.setWidgetViewVisible(true);
    }

    public abstract String getWidgetTitleText();

    public abstract String getWidgetSubtitleText();

    public abstract int getWidgetIconId();

    public abstract int getWidgetViewId();

    public abstract View.OnClickListener getOnCardClickListener();

    public abstract boolean isCardClickable();
}

