/*
 * Decompiled with CFR 0.152.
 */
package com.github.anzewei.parallaxbacklayout.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.IntDef;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import com.github.anzewei.parallaxbacklayout.R;
import com.github.anzewei.parallaxbacklayout.ViewDragHelper;
import com.github.anzewei.parallaxbacklayout.transform.CoverTransform;
import com.github.anzewei.parallaxbacklayout.transform.ITransform;
import com.github.anzewei.parallaxbacklayout.transform.ParallaxTransform;
import com.github.anzewei.parallaxbacklayout.transform.SlideTransform;
import com.github.anzewei.parallaxbacklayout.widget.ShadowDrawable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ParallaxBackLayout
extends FrameLayout {
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final int FULL_ALPHA = 255;
    private static final float DEFAULT_SCROLL_THRESHOLD = 0.5f;
    private static final int OVERSCROLL_DISTANCE = 0;
    private static final int EDGE_LEFT = 1;
    public static final int LAYOUT_PARALLAX = 1;
    public static final int LAYOUT_COVER = 0;
    public static final int LAYOUT_SLIDE = 2;
    public static final int LAYOUT_CUSTOM = -1;
    public static final int EDGE_MODE_FULL = 0;
    public static final int EDGE_MODE_DEFAULT = 1;
    private float mScrollThreshold = 0.5f;
    private Activity mSwipeHelper;
    private Rect mInsets = new Rect();
    private boolean mEnable = true;
    private View mContentView;
    private ViewDragHelper mDragHelper = ViewDragHelper.create((ViewGroup)this, new ViewDragCallback());
    private ParallaxSlideCallback mSlideCallback;
    private ITransform mTransform;
    private int mContentLeft;
    private int mEdgeMode = 1;
    private int mContentTop;
    private int mLayoutType = 1;
    private IBackgroundView mBackgroundView;
    private Drawable mShadowLeft;
    private boolean mInLayout;
    private int mTrackingEdge;
    private int mFlingVelocity = 30;
    private int mEdgeFlag = -1;

    public ParallaxBackLayout(Context context) {
        super(context);
        this.setEdgeFlag(1);
    }

    @TargetApi(value=20)
    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        int top = insets.getSystemWindowInsetTop();
        if (this.mContentView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mContentView.getLayoutParams();
            this.mInsets.set(params.leftMargin, params.topMargin + top, params.rightMargin, params.bottomMargin);
        }
        this.applyWindowInset();
        return super.onApplyWindowInsets(insets);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.mEnable || !this.mBackgroundView.canGoBack()) {
            return false;
        }
        try {
            return this.mDragHelper.shouldInterceptTouchEvent(event);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnable || !this.mBackgroundView.canGoBack()) {
            return false;
        }
        this.mDragHelper.processTouchEvent(event);
        return true;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mInLayout = true;
        this.applyWindowInset();
        if (this.mContentView != null) {
            int cleft = this.mContentLeft;
            int ctop = this.mContentTop;
            Log.d((String)"View", (String)("left = " + left + " top = " + top));
            ViewGroup.LayoutParams params = this.mContentView.getLayoutParams();
            if (params instanceof ViewGroup.MarginLayoutParams) {
                cleft += ((ViewGroup.MarginLayoutParams)params).leftMargin;
                ctop += ((ViewGroup.MarginLayoutParams)params).topMargin;
            }
            this.mContentView.layout(cleft, ctop, cleft + this.mContentView.getMeasuredWidth(), ctop + this.mContentView.getMeasuredHeight());
        }
        this.mInLayout = false;
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    public void computeScroll() {
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean drawContent;
        Log.d((String)"View", (String)"drawChild");
        boolean bl = drawContent = child == this.mContentView;
        if (this.mEnable) {
            this.drawThumb(canvas, child);
        }
        boolean ret = super.drawChild(canvas, child, drawingTime);
        if (this.mEnable && drawContent && this.mDragHelper.getViewDragState() != 0) {
            this.drawShadow(canvas, child);
        }
        return ret;
    }

    private void setContentView(View view) {
        this.mContentView = view;
    }

    private void applyWindowInset() {
        if (this.mInsets == null) {
            return;
        }
        if (this.mEdgeMode == 0) {
            this.mDragHelper.setEdgeSize(Math.max(this.getWidth(), this.getHeight()));
        } else if (this.mEdgeFlag == 4) {
            this.mDragHelper.setEdgeSize(this.mInsets.top + this.mDragHelper.getEdgeSizeDefault());
        } else if (this.mEdgeFlag == 8) {
            this.mDragHelper.setEdgeSize(this.mInsets.bottom + this.mDragHelper.getEdgeSizeDefault());
        } else if (this.mEdgeFlag == 1) {
            this.mDragHelper.setEdgeSize(this.mDragHelper.getEdgeSizeDefault() + this.mInsets.left);
        } else {
            this.mDragHelper.setEdgeSize(this.mDragHelper.getEdgeSizeDefault() + this.mInsets.right);
        }
    }

    private void drawThumb(Canvas canvas, View child) {
        if (this.mContentLeft == 0 && this.mContentTop == 0) {
            return;
        }
        int store = canvas.save();
        this.mTransform.transform(canvas, this, child);
        this.mBackgroundView.draw(canvas);
        canvas.restoreToCount(store);
    }

    private void drawShadow(Canvas canvas, View child) {
        if (this.mContentLeft == 0 && this.mContentTop == 0) {
            return;
        }
        if (this.mShadowLeft == null) {
            return;
        }
        if (this.mEdgeFlag == 1) {
            this.mShadowLeft.setBounds(child.getLeft() - this.mShadowLeft.getIntrinsicWidth(), child.getTop(), child.getLeft(), child.getBottom());
            this.mShadowLeft.setAlpha((this.getWidth() - child.getLeft()) * 255 / this.getWidth());
        } else if (this.mEdgeFlag == 2) {
            this.mShadowLeft.setBounds(child.getRight(), child.getTop(), child.getRight() + this.mShadowLeft.getIntrinsicWidth(), child.getBottom());
            this.mShadowLeft.setAlpha(child.getRight() * 255 / this.getWidth());
        } else if (this.mEdgeFlag == 8) {
            this.mShadowLeft.setBounds(child.getLeft(), child.getBottom(), child.getRight(), child.getBottom() + this.mShadowLeft.getIntrinsicHeight());
            this.mShadowLeft.setAlpha(child.getBottom() * 255 / this.getHeight());
        } else if (this.mEdgeFlag == 4) {
            this.mShadowLeft.setBounds(child.getLeft(), child.getTop() - this.mShadowLeft.getIntrinsicHeight() + this.getSystemTop(), child.getRight(), child.getTop() + this.getSystemTop());
            this.mShadowLeft.setAlpha((this.getHeight() - child.getTop()) * 255 / this.getHeight());
        }
        this.mShadowLeft.draw(canvas);
    }

    public void setEnableGesture(boolean enable) {
        this.mEnable = enable;
    }

    public void setSlideCallback(ParallaxSlideCallback slideCallback) {
        this.mSlideCallback = slideCallback;
    }

    public void setScrollThresHold(float threshold) {
        if (threshold >= 1.0f || threshold <= 0.0f) {
            throw new IllegalArgumentException("Threshold value should be between 0 and 1.0");
        }
        this.mScrollThreshold = threshold;
    }

    public void setVelocity(int velocity) {
        this.mFlingVelocity = velocity;
    }

    public void attachToActivity(Activity activity) {
        this.mSwipeHelper = activity;
        ViewGroup decor = (ViewGroup)activity.getWindow().getDecorView();
        ViewGroup decorChild = (ViewGroup)decor.getChildAt(0);
        decor.removeView((View)decorChild);
        this.addView((View)decorChild, -1, -1);
        this.setContentView((View)decorChild);
        decor.addView((View)this);
    }

    public void setEdgeMode(int mode) {
        this.mEdgeMode = mode;
        this.applyWindowInset();
    }

    public boolean scrollToFinishActivity(int duration) {
        if (!this.mEnable || !this.mBackgroundView.canGoBack()) {
            return false;
        }
        int childWidth = this.getWidth();
        int left = 0;
        int top = 0;
        this.mTrackingEdge = this.mEdgeFlag;
        switch (this.mTrackingEdge) {
            case 1: {
                left = childWidth;
                break;
            }
            case 8: {
                top = -this.getHeight();
                break;
            }
            case 2: {
                left = -this.getWidth();
                break;
            }
            case 4: {
                top = this.getHeight();
            }
        }
        if (this.mDragHelper.smoothSlideViewTo(this.mContentView, left, top, duration)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
            this.postInvalidate();
            return true;
        }
        return false;
    }

    public void setShadowDrawable(Drawable drawable) {
        this.mShadowLeft = drawable;
    }

    public void setBackgroundView(IBackgroundView backgroundView) {
        this.mBackgroundView = backgroundView;
    }

    public int getEdgeFlag() {
        return this.mEdgeFlag;
    }

    @TargetApi(value=16)
    public void setEdgeFlag(int edgeFlag) {
        if (this.mEdgeFlag == edgeFlag) {
            return;
        }
        this.mEdgeFlag = edgeFlag;
        this.mDragHelper.setEdgeTrackingEnabled(edgeFlag);
        GradientDrawable.Orientation orientation = GradientDrawable.Orientation.LEFT_RIGHT;
        if (edgeFlag == 1) {
            orientation = GradientDrawable.Orientation.RIGHT_LEFT;
        } else if (edgeFlag == 4) {
            orientation = GradientDrawable.Orientation.BOTTOM_TOP;
        } else if (edgeFlag == 2) {
            orientation = GradientDrawable.Orientation.LEFT_RIGHT;
        } else if (edgeFlag == 8) {
            orientation = GradientDrawable.Orientation.TOP_BOTTOM;
        }
        if (Build.VERSION.SDK_INT < 16) {
            this.mShadowLeft = null;
        }
        if (this.mShadowLeft == null) {
            int[] colors = new int[]{0x66000000, 0x11000000, 0};
            ShadowDrawable drawable = new ShadowDrawable(orientation, colors);
            drawable.setGradientRadius(90.0f);
            drawable.setSize(50, 50);
            this.mShadowLeft = drawable;
        } else if (this.mShadowLeft instanceof ShadowDrawable) {
            ((ShadowDrawable)this.mShadowLeft).setOrientation(orientation);
        }
        this.applyWindowInset();
    }

    public int getSystemTop() {
        return this.mInsets.top;
    }

    public int getSystemLeft() {
        return this.mInsets.left;
    }

    public int getLayoutType() {
        return this.mLayoutType;
    }

    public void setLayoutType(int layoutType, ITransform transform) {
        this.mLayoutType = layoutType;
        switch (layoutType) {
            case -1: {
                assert (transform != null);
                this.mTransform = transform;
                break;
            }
            case 0: {
                this.mTransform = new CoverTransform();
                break;
            }
            case 1: {
                this.mTransform = new ParallaxTransform();
                break;
            }
            case 2: {
                this.mTransform = new SlideTransform();
            }
        }
    }

    public static interface ParallaxSlideCallback {
        public void onStateChanged(int var1);

        public void onPositionChanged(float var1);
    }

    public static interface IBackgroundView {
        public void draw(Canvas var1);

        public boolean canGoBack();
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private float mScrollPercent;

        private ViewDragCallback() {
        }

        @Override
        public boolean tryCaptureView(View view, int pointerId) {
            boolean ret = ParallaxBackLayout.this.mDragHelper.isEdgeTouched(ParallaxBackLayout.this.mEdgeFlag, pointerId);
            if (ret) {
                ParallaxBackLayout.this.mTrackingEdge = ParallaxBackLayout.this.mEdgeFlag;
            }
            boolean directionCheck = false;
            if (ParallaxBackLayout.this.mEdgeFlag == 1 || ParallaxBackLayout.this.mEdgeFlag == 2) {
                directionCheck = !ParallaxBackLayout.this.mDragHelper.checkTouchSlop(2, pointerId);
            } else if (ParallaxBackLayout.this.mEdgeFlag == 8 || ParallaxBackLayout.this.mEdgeFlag == 4) {
                directionCheck = !ParallaxBackLayout.this.mDragHelper.checkTouchSlop(1, pointerId);
            }
            return ret & directionCheck;
        }

        @Override
        public int getViewHorizontalDragRange(View child) {
            return ParallaxBackLayout.this.mEdgeFlag & 3;
        }

        @Override
        public int getViewVerticalDragRange(View child) {
            return ParallaxBackLayout.this.mEdgeFlag & 0xC;
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                this.mScrollPercent = Math.abs((float)(left - ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left) / (float)ParallaxBackLayout.this.mContentView.getWidth());
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 2) != 0) {
                this.mScrollPercent = Math.abs((float)(left - ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left) / (float)ParallaxBackLayout.this.mContentView.getWidth());
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 8) != 0) {
                this.mScrollPercent = Math.abs((float)(top - ParallaxBackLayout.this.getSystemTop()) / (float)ParallaxBackLayout.this.mContentView.getHeight());
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 4) != 0) {
                this.mScrollPercent = Math.abs((float)top / (float)ParallaxBackLayout.this.mContentView.getHeight());
            }
            ParallaxBackLayout.this.mContentLeft = left;
            ParallaxBackLayout.this.mContentTop = top;
            ParallaxBackLayout.this.invalidate();
            if (ParallaxBackLayout.this.mSlideCallback != null) {
                ParallaxBackLayout.this.mSlideCallback.onPositionChanged(this.mScrollPercent);
            }
            if (this.mScrollPercent >= 0.999f && !ParallaxBackLayout.this.mSwipeHelper.isFinishing()) {
                ParallaxBackLayout.this.mSwipeHelper.finish();
                ParallaxBackLayout.this.mSwipeHelper.overridePendingTransition(0, R.anim.parallax_exit);
            }
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int childWidth = releasedChild.getWidth();
            int childHeight = releasedChild.getHeight();
            boolean fling = false;
            int left = ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left;
            int top = 0;
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                if (Math.abs(xvel) > (float)ParallaxBackLayout.this.mFlingVelocity) {
                    fling = true;
                }
                int n = left = xvel >= 0.0f && (fling || this.mScrollPercent > ParallaxBackLayout.this.mScrollThreshold) ? childWidth + ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left : ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left;
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 2) != 0) {
                if (Math.abs(xvel) > (float)ParallaxBackLayout.this.mFlingVelocity) {
                    fling = true;
                }
                int n = left = xvel <= 0.0f && (fling || this.mScrollPercent > ParallaxBackLayout.this.mScrollThreshold) ? -childWidth + ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left : ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left;
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 4) != 0) {
                if (Math.abs(yvel) > (float)ParallaxBackLayout.this.mFlingVelocity) {
                    fling = true;
                }
                int n = top = yvel >= 0.0f && (fling || this.mScrollPercent > ParallaxBackLayout.this.mScrollThreshold) ? childHeight : 0;
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 8) != 0) {
                if (Math.abs(yvel) > (float)ParallaxBackLayout.this.mFlingVelocity) {
                    fling = true;
                }
                top = yvel <= 0.0f && (fling || this.mScrollPercent > ParallaxBackLayout.this.mScrollThreshold) ? -childHeight + ParallaxBackLayout.this.getSystemTop() : 0;
            }
            ParallaxBackLayout.this.mDragHelper.settleCapturedViewAt(left, top);
            ParallaxBackLayout.this.invalidate();
        }

        @Override
        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            if (ParallaxBackLayout.this.mSlideCallback != null) {
                ParallaxBackLayout.this.mSlideCallback.onStateChanged(state);
            }
        }

        @Override
        public int clampViewPositionHorizontal(View child, int left, int dx) {
            int ret = ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left;
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                ret = Math.min(child.getWidth(), Math.max(left, 0));
            } else if ((ParallaxBackLayout.this.mTrackingEdge & 2) != 0) {
                ret = Math.min(((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left, Math.max(left, -child.getWidth()));
            }
            return ret;
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            int ret = ParallaxBackLayout.this.mContentView.getTop();
            if ((ParallaxBackLayout.this.mTrackingEdge & 8) != 0) {
                ret = Math.min(0, Math.max(top, -child.getHeight()));
            } else if ((ParallaxBackLayout.this.mTrackingEdge & 4) != 0) {
                ret = Math.min(child.getHeight(), Math.max(top, 0));
            }
            return ret;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 0L})
    public static @interface EdgeMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L, 4L, 8L})
    public static @interface Edge {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, -1L})
    public static @interface LayoutType {
    }
}

