/*
 * Decompiled with CFR 0.152.
 */
package com.github.anzewei.parallaxbacklayout;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.view.View;
import com.github.anzewei.parallaxbacklayout.ParallaxBackLayout;
import java.util.Stack;

public class ParallaxBackActivityHelper {
    private static final Stack<ParallaxBackActivityHelper> sActivities = new Stack();
    private Activity mActivity;
    private ParallaxBackLayout mParallaxBackLayout;

    public Activity getActivity() {
        return this.mActivity;
    }

    public ParallaxBackActivityHelper(Activity activity) {
        this.mActivity = activity;
        this.mParallaxBackLayout = new ParallaxBackLayout((Context)this.mActivity);
        sActivities.push(this);
    }

    public void onPostCreate() {
        this.mParallaxBackLayout.attachToActivity(this);
    }

    public void onActivityDestroy() {
        sActivities.remove(this);
    }

    public ParallaxBackActivityHelper getSecondActivity() {
        if (sActivities.size() >= 2) {
            return (ParallaxBackActivityHelper)sActivities.elementAt(sActivities.size() - 2);
        }
        return null;
    }

    public void drawThumb(Canvas canvas) {
        View decorChild = this.getBackLayout().getContentView();
        decorChild.draw(canvas);
    }

    public View findViewById(int id) {
        if (this.mParallaxBackLayout != null) {
            return this.mParallaxBackLayout.findViewById(id);
        }
        return null;
    }

    public void scrollToFinishActivity() {
        this.getBackLayout().scrollToFinishActivity();
    }

    public void setBackEnable(boolean enable) {
        this.getBackLayout().setEnableGesture(enable);
    }

    public ParallaxBackLayout getBackLayout() {
        return this.mParallaxBackLayout;
    }
}

