/*
 * Decompiled with CFR 0.152.
 */
package com.github.anhadmathur.marshrtp;

import android.support.annotation.NonNull;
import com.github.anhadmathur.marshrtp.PermissionResult;
import java.util.HashMap;

public class PermissionResultStatus {
    private final PermissionResult[] mResults;
    private HashMap<String, Boolean> mResultHashMap;

    private PermissionResultStatus(PermissionResult[] result) {
        this.mResults = result;
    }

    public static PermissionResultStatus generateResultSet(@NonNull String[] permissions, int[] grantResults) {
        PermissionResult[] resultSet = new PermissionResult[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            resultSet[i] = new PermissionResult(permissions[i], grantResults[i]);
        }
        PermissionResultStatus resultStatus = new PermissionResultStatus(resultSet);
        resultStatus.setPermissionResultSet(resultSet);
        return resultStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allPermissionsGranted() {
        PermissionResult[] tempResult = this.mResults;
        PermissionResult[] permissionResultArray = this.mResults;
        synchronized (this.mResults) {
            boolean bool = true;
            for (int i = 0; i < tempResult.length; ++i) {
                if (tempResult[i].isGranted()) continue;
                bool = false;
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bool;
        }
    }

    public HashMap<String, Boolean> getPermissionResultSet() {
        if (this.mResultHashMap != null) {
            return this.mResultHashMap;
        }
        return null;
    }

    public void setPermissionResultSet(PermissionResult[] mResults) {
        this.mResultHashMap = new HashMap();
        for (int i = 0; i < mResults.length; ++i) {
            PermissionResult result = mResults[i];
            this.mResultHashMap.put(result.getPermission(), result.isGranted());
        }
    }

    public boolean isPermissionGranted(String permissionName) throws IllegalStateException {
        int i = 0;
        HashMap<String, Boolean> map = this.getPermissionResultSet();
        if (i < map.size()) {
            if (map.containsKey(permissionName)) {
                return map.get(permissionName);
            }
            throw new IllegalStateException("You have not requested the " + permissionName + " Permission");
        }
        return false;
    }
}

